知识文档RESTful API说明文档



## 1.  RESTful API 设计规范与约定说明

### 1.1  **路径规则（Endpoint rule）**

路径又称"终点"（endpoint），表示API的具体网址。

在RESTful架构中，每个网址代表一种资源（resource），所以网址中不能有动词，只能有名词，而且所用的名词往往与数据库的表格名对应。一般来说，数据库中的表都是同种记录的"集合"（collection），所以API中的名词也应该使用复数。

举例来说，有一组API分别提供Document、表单、视图的信息，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/documents

-   https://api.example.com/runtime/forms

-   https://api.example.com/runtime/views
```

以上路径规则是面向资源的，对于CRUD操作是非常友好的，但是面向一些“动作”或“行为”等一些不符合CRUD的服务请求（如操作按钮的运行执行前脚本），单纯的面向资源的路径构建规则就会让人困惑了。

这种情况我们可以以“子资源”来对待（资源后面加行为动词），例如:GitHub上，对一个gists加星操作：

```
PUT /gists/:id/star
```

并且取消星操作：

```
DELETE /gists/:id/star
```

举例来说，有一组API分别提供执行操作按钮的执行前、执行后脚本和业务处理行为，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/activitys/{id}/excute

-   https://api.example.com/runtime/activitys/{id}/beforactionscript

-   https://api.example.com/runtime/activitys/{id}/afteractionscript
```

### 1.2  **HTTP动词 (Http method)**

对于资源的具体操作类型，由HTTP动词表示。

常用的HTTP动词有下面五个（括号里是对应的SQL命令）。

```
-   GET（SELECT）：从服务器取出资源（一项或多项）。

-   POST（CREATE）：在服务器新建一个资源。

-   PUT（UPDATE）：在服务器更新资源（客户端提供改变后的完整资源）。

-   PATCH（UPDATE）：在服务器更新资源（客户端提供改变的属性）。

-   DELETE（DELETE）：从服务器删除资源。
```

下面是一些例子。

```
-   GET /runtime/documents：获取Document集合

-   POST /runtime/documents：新建一个Document

-   GET /runtime/documents/{id}：获取由ID指定的Document

-   PUT /runtime/documents/{id}：更新由ID指定的Document（客户端提供全部信息，完整更新）

-   PATCH /runtime/documents/{id}：更新由ID指定的Document（客户端提供部分信息，局部更新）

-   DELETE /runtime/documents/{id}：删除由ID指定的Document
```

### 1.3  **过滤信息（Filtering）**

如果记录数量很多，服务器不可能都将它们返回给用户。API应该提供参数，过滤返回结果。

下面是一些常见的参数。

```
-   ?_page=2&_page_lines=30：指定第几页，以及每页的记录数。

-   ?_sortby=name&_order=asc：指定返回结果按照哪个属性排序，以及排序顺序。

-   ?form_type =1：指定筛选条件。
```

参数的设计允许存在冗余，即允许API路径和URL参数偶尔有重复。比如，

```
GET /runtime/documents/{id}/flowhis
```

 与 

```
GET /runtime/flowhis?doc_id={id}
```

的含义是相同的。

### 1.4 **状态码（Status codes）**

------

服务器向用户返回的状态码和提示信息，常见的有以下一些（方括号中是该状态码对应的HTTP动词）。

下面是一些常见的状态码。

```
-   200 OK - [GET]：服务器成功返回用户请求的数据，该操作是幂等的（Idempotent）。

-   201 CREATED - [POST/PUT/PATCH]：用户新建或修改数据成功。

-   202 Accepted - [\*]：表示一个请求已经进入后台排队（异步任务）

-   204 NO CONTENT - [DELETE]：用户删除数据成功。

-   400 INVALID REQUEST -
    [POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作，该操作是幂等的。

-   401 Unauthorized - [\*]：表示用户没有权限（令牌、用户名、密码错误）。

-   403 Forbidden - [\*] 表示用户得到授权（与401错误相对），但是访问是被禁止的。

-   404 NOT FOUND -
    [\*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的。

-   406 Not Acceptable -
    [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）。

-   410 Gone -[GET]：用户请求的资源被永久删除，且不会再得到的。

-   422 Unprocesable entity - [POST/PUT/PATCH]
    当创建一个对象时，发生一个验证错误。

-   500 INTERNAL SERVER ERROR -
    [\*]：服务器发生错误，用户将无法判断发出的请求是否成功。
```

### 1.5  **错误处理（Error handling）**

就像html错误页面能够显示错误信息一样，API
也应该能返回可读的错误信息，它应该和一般的资源格式一致。

- API应该始终返回相应的状态码，以反映服务器或者请求的状态。
- API的错误码可以分为两部分，400系列和500系列，400系列表明客户端错误：如错误的请求格式等。500系列表示服务器错误。
- API应该至少将所有的400系列的错误以JSON形式返回。如果可能500系列的错误也应该如此。
- JSON格式的错误应该包含以下信息：一个有用的错误信息，一个唯一的错误码，以及任何可能的详细错误描述。如下：

```
{
  "errcode" : 40035,
  "errmsg" : "不合法的参数"
}

```

- 对PUT,POST,PATCH的输入的校验也应该返回相应的详细错误信息，例如：

```
{  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 1234,  
              "field" : "first_name",  
              "errmsg" : "First name cannot have fancy characters"  
            },  
            {  
               "errcode" : 1234,  
               "field" : "password",  
               "errmsg" : "Password cannot be blank"  
            }  
          ]  
        }

```

### 1.6 **数据结构（Data structure）**

- 在POST,PUT,PATCH上使用JSON作为输入。
- 注意使用JSON传输的时候，要求请求头里面加入：Content-Type：applicatin/json.否则抛出415异常（unsupported
  media type）。
- 服务器返回的数据格式，统一使用JSON作为输出。

> 服务器返回的JSON数据结构统一如下：

```
{
  "errcode" : 0,
  "errmsg" : "some message",
  "data" : {},
  "errors" : []
}

```

> 参数说明：

| 参数    | 必须 | 说明                 |
| ------- | ---- | -------------------- |
| errcode | 是   | 状态码/返回码        |
| errmsg  | 是   | 消息                 |
| data    | 是   | 服务端返回的数据对象 |
| errors  | 否   | 详细错误信息         |

### 1.7 **其他**

1. 客户端控制服务端是否需要返回数据、且返回哪些数据的约定

2. Urls命名规则统一使用蛇形命名法（下划线和小写）



   # 网盘（Disks）

   ## 获取部门网盘集合

**请求方式：**GET  
**请求地址：**/kms/disks/departments

**权限说明：**

无。

**返回结果：**

```json
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 4,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "11a2667d-4ba0-44fd-b697-dfbd4c4d9648",
			"name": "产品部",
			"type": 1,
			"domainId": "uumsxrgm1KEEqSZIoHs",
			"ownerId": "BFMzxTaCTWI6TbWLKXT",
			"orderNo": 1
		}, {
			"id": "221f779a-c800-4797-a88e-2940d58a6650",
			"name": "前端组",
			"type": 1,
			"domainId": "uumsxrgm1KEEqSZIoHs",
			"ownerId": "JhBTBO1uKkwujgrdORM",
			"orderNo": 1
		}, {
			"id": "7302bac1-b047-4f69-ae77-5bc11c25df0f",
			"name": "开发组",
			"type": 1,
			"domainId": "uumsxrgm1KEEqSZIoHs",
			"ownerId": "__qc4igLcF19TU2Jvjlwp",
			"orderNo": 1
		}, {
			"id": "7410e226-ed8b-4eea-8d5c-585a5503891d",
			"name": "后勤部",
			"type": 1,
			"domainId": "uumsxrgm1KEEqSZIoHs",
			"ownerId": "PNVhNFCjYS2DDUoP7b7",
			"orderNo": 1
		}],
		"pageCount": 1
	}
}

```



**参数说明：**

| **参数** | **说明**                                    |
|----------|---------------------------------------------|
| errcode  | 返回码                                      |
| errmsg   | 对返回码的文本描述内容                      |
| data     | Disk对象，详情请看[Disk对象说明](#disk网盘) |

创建部门网盘
------------

**请求方式：POST**  
**请求地址：**/kms/disks/departments

**请求包体**：

```json
[
    " id1",
    "id2",
    "id3"
]

```



**参数说明：**

| **参数** | **必须** | **说明**   |
|----------|----------|------------|
| deptIds  | 是       | 部门Id数组 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}

```



| **参数** | **说明**                                    |
|----------|---------------------------------------------|
| errcode  | 返回码                                      |
| errmsg   | 对返回码的文本描述内容                      |
| data     | Disk对象，详情请看[Disk对象说明](#disk网盘) |

删除部门网盘
------------

**请求方式：DELETE**

**请求地址：**/kms/disks/{:diskId}

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :diskId  | 是       | 网盘Id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": true
}
```



| **参数** | **说明**                                    |
|----------|---------------------------------------------|
| errcode  | 返回码                                      |
| errmsg   | 对返回码的文本描述内容                      |
| data     | Disk对象，详情请看[Disk对象说明](#disk网盘) |

更新部门网盘
------------

**请求方式：PUT**  
**请求地址：**/kms/disks/{:diskId}

**请求包体**：

```json
{
    "id": "45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
    "name": "江苏省邮电规划设计院",
    "type": 1,
    "ownerId": "11e7-7045-1c91a1dc-85f9-cbfc8973e987",
    "orderNo": 98
}

```



**参数说明：**

| **参数** | **必须** | **说明**   |
|----------|----------|------------|
| :diskId  | 是       | 网盘ID     |
| id       | 是       | 网盘ID     |
| name     | 是       | 网盘名称   |
| type     | 是       | 网盘类型   |
| ownerId  | 是       | 网盘所有者 |
| orderNo  | 是       | 排序号     |
|          |          |            |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id":"4f00e65e-94a0-4c2a-b50f-c64d7f6bdc3e",
        "name":"测试数据",
        "type":1,
        "ownerId":"11e7-7045-2da34ac9-85f9-cbfc8973e987",
        "orderNo":25
    }
}
```



| **参数** | **说明**                                    |
|----------|---------------------------------------------|
| errcode  | 返回码                                      |
| errmsg   | 对返回码的文本描述内容                      |
| data     | Disk对象，详情请看[Disk对象说明](#disk网盘) |

网盘下的预览和下载的次数
------------------------

网盘下的预览和下载的集合

**请求方式：GET**  
**请求地址：**/kms/disks/{diskId}/files/viewsAndDownloads

**参数说明：**

| **参数** | **说明** |
|----------|----------|
| diskId   | 网盘id   |

**权限说明：**

预览和下载次数的显示，只针对部门km

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "views":3,
        "downloads":3
    }
}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

2.6获取部门网盘的管理员
-----------------------

获取部门网盘的管理员

**请求方式：GET**  
**请求地址：**/kms/disks/{diskId}/superadmins

**参数说明：**

| **参数** | **说明** |
|----------|----------|
| diskId   | 网盘id   |

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":[
        {
            "id":"11e7-a198-c5a5aeea-a900-73852bc58bcf",
            "name":"铁塔院管理员",
            "nameLetter":"ttygly",
            "loginno":"ttyadmin",
            "email":"",
            "telephone":"",
            "avatar":"",
            "favoriteContacts":"",
            "superior":null,
            "roles":[
                {
                    "id":"0001",
                    "name":"员工",
                    "levels":0
                },
                {
                    "id":"0010",
                    "name":"部门知识管理员",
                    "levels":10
                },
                {
                    "id":"0020",
                    "name":"专委会知识管理员",
                    "levels":20
                }],
            "domainid":"11e7-a197-b8af019e-a900-73852bc58bcf",
            "defaultDepartment":"11e7-a198-36b48314-a900-73852bc58bcf",
            "calendarType":"11e7-a197-b8cdad30-a900-73852bc58bcf",
            "status":1,
            "level":0
        }]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

1.  目录（Folders）

    1.  目录创建

**请求方式：**POST  
**请求地址：**/kms/disks/:diskId/folders

**请求包体**：

```json
{
    "name": "value",
    "diskId": "value",
    "folderId":"value"
}
```



**参数说明：**

| **参数** | **必须** | **说明**                             |
|----------|----------|--------------------------------------|
| :diskId  | 是       | 网盘ID                               |
| name     | 是       | 目录名称                             |
| diskId   | 是       | 目录所在的网盘ID                     |
| folderId | 是       | 目录的上级目录ID，根目录的ID为网盘ID |

**权限说明：**

无。

**返回结果:**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"bea126f8-7637-452b-babb-b50ff9fe6e80",
        "name":"新建目录22",
        "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
        "creator":"邢专员（行政专员）",
        "createDate":1502158542785,
        "lastModifyDate":1502158542785,
        "diskId":"45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
        "folderId":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "folder":true,
        "size":0,
        "path":"\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\\\5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "orderNo":0,
        "type":0
    }
}

```



**参数说明：**

| **参数** | **说明**                                           |
|----------|----------------------------------------------------|
| errcode  | 返回码                                             |
| errmsg   | 对返回码的文本描述内容                             |
| data     | Folder对象，详情请看[Folder对象说明](#folder-目录) |

目录置顶
--------

目录置顶功能。

**请求方式：**PATCH  
**请求地址：**/kms/disks/:diskId/folders/:folderId /top

**参数说明：**

| **参数**  | **必须** | **说明**   |
|-----------|----------|------------|
| :diskId   | 是       | 网盘id     |
| :folderId | 是       | 置顶目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"bea126f8-7637-452b-babb-b50ff9fe6e80",
        "name":"新建目录22",
        "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
        "creator":"邢专员（行政专员）",
        "createDate":1502158542785,
        "lastModifyDate":1502158542785,
        "diskId":"45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
        "folderId":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "folder":true,
        "size":0,
        "path":"\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\\\5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "orderNo":0,
        "type":0
    }
}

```

**参数说明：**

| **参数** | **说明**                                           |
|----------|----------------------------------------------------|
| errcode  | 返回码                                             |
| errmsg   | 对返回码的文本描述内容                             |
| data     | Folder对象，详情请看[Folder对象说明](#folder-目录) |

目录重命名
----------

**请求方式：**PATCH  
**请求地址：**/kms/disks/:diskId/folders/:folderId/rename

**请求包体：**

```json
{
    "name":"name"
}
```



**参数说明：**

| **参数**  | **必须** | **说明**     |
|-----------|----------|--------------|
| :diskId   | 是       | 网盘id       |
| :folderId | 是       | 目录id       |
| :name     | 是       | 重命名的名称 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"bea126f8-7637-452b-babb-b50ff9fe6e80",
        "name":"新建目录22",
        "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
        "creator":"邢专员（行政专员）",
        "createDate":1502158542785,
        "lastModifyDate":1502158542785,
        "diskId":"45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
        "folderId":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "folder":true,
        "size":0,
        "path":"\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\\\5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "orderNo":0,
        "type":0
    }
}

```



**参数说明：**

| **参数** | **说明**                                           |
|----------|----------------------------------------------------|
| errcode  | 返回码                                             |
| errmsg   | 对返回码的文本描述内容                             |
| data     | Folder对象，详情请看[Folder对象说明](#folder-目录) |

单个目录移动
------------

>   作用于移动单个目录时。

**请求方式：PATCH**  
**请求地址：**/kms/disks/:diskId/folders/:folderId/moveto/folderId/:destFolderId

**参数说明：**

| **参数**      | **必须** | **说明**   |
|---------------|----------|------------|
| :diskId       | 是       | 网盘id     |
| :folderId     | 是       | 目录id     |
| :destFolderId | 是       | 目标目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}

```



**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

单个目录下载
------------

。

**请求方式：**GET  
**请求地址：/kms/downloads**

**请求包体：**

**请求包体：**

           

**参数说明：**

| **参数**    | **必须** | **说明**   |
|-------------|----------|------------|
| : folderIds | 是       | 目录id集合 |
| ：fileIds   | 是       | 传空       |

**权限说明：**

无。

**返回结果：**

```json

```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

单个目录删除
------------

。

**请求方式：**DELETE  
**请求地址：**/kms/disk/:diskId/folders/:folderId

**参数说明：**

| **参数**  | **必须** | **说明**   |
|-----------|----------|------------|
| :diskId   | 是       | 网盘id     |
| :folderId | 是       | 删除目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}

```



**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

获取目录树
----------

**请求方式：**GET  
**请求地址：**/kms/disk/:diskId/foldersTree

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :diskId  | 是       | 网盘id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "name":"一级目1_3",
            "id":"1cbf5e54-ce72-4199-89a0-cb792f120fde"
        },
        {
            "name":"一级目1_1",
            "id":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
            "childern":[
                {
                    "name":"二级1_1_2_2",
                    "id":"3d427cf6-5483-4d1e-a026-bcacd3d230ee"
                },
                {
                    "name":"二级目1_1_2_3",
                    "id":"81964e30-f7ad-4fa0-9ec4-2660dcc92744"
                }
            ]
        },
        {
            "name":"新建文件夹",
            "id":"fe8f5c12-8f17-4eac-9f58-e01821f23a0c"
        }]
}

```



**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     |                        |

获取目录路劲
------------

**请求方式：**GET  
**请求地址：**/kms /disks/folders/{folderId}

**参数说明：**

| **参数**  | **必须** | **说明** |
|-----------|----------|----------|
| :folderId | 是       | 目录id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "权限设置/铁塔院可下载/铁塔院可预览"
}
```



**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     |                        |

3.8 取消目录置顶
----------------

取消目录置顶功能。

**请求方式：**DELETEs  
**请求地址：**/kms/disks/:diskId/folders/:folderId /top

**参数说明：**

| **参数**  | **必须** | **说明**   |
|-----------|----------|------------|
| :diskId   | 是       | 网盘id     |
| :folderId | 是       | 置顶目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"bea126f8-7637-452b-babb-b50ff9fe6e80",
        "name":"新建目录22",
        "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
        "creator":"邢专员（行政专员）",
        "createDate":1502158542785,
        "lastModifyDate":1502158542785,
        "diskId":"45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
        "folderId":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "folder":true,
        "size":0,
        "path":"\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\\\5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "orderNo":0,
        "type":0
    }
}
```



**参数说明：**

| **参数** | **说明**                                           |
|----------|----------------------------------------------------|
| errcode  | 返回码                                             |
| errmsg   | 对返回码的文本描述内容                             |
| data     | Folder对象，详情请看[Folder对象说明](#folder-目录) |

# 文件（Files）

## 目录下的文件列表

查询每个目录下的文件列表。

备注：根目录为网盘的ID

**请求方式：**GET  
**请求地址：**/kms/disks/:diskId/folders/:folders/files?fileName=:orderByfield=:&orderMode=:pageNo=:&linesPerPage

**参数说明：**

| **参数**       | **必须** | **说明**                              |
|----------------|----------|---------------------------------------|
| :disked        | 是       | 网盘id                                |
| :folderId      | 是       | 目录id                                |
| filename=:     | 是       | 文件名                                |
| orderByfield=: | 是       | 属性名(NAME CREATOR LAST_MODIFY_DATE) |
| orderMode=:    | 是       | 升序(ASC)/降序(DESC)                  |
| pageNo=:       | 是       | 当前页                                |
| linesPerPage=: | 是       | 每页显示条数                          |

orderByfield是根据数据库的属性，如：名称：NAME,最后修改时间：LAST_MODIFY_DATE,创建者:CREATOR

orderByfield,orderMode统一为大写

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 8,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [
            {
                "id": "687aa9c6-df3c-42c5-9be9-929fed7cae5c",
                "name": "新建目录",
                "creatorId": null,
                "creator": null,
                "createDate": null,
                "lastModifyDate": null,
                "diskId": "45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
                "folderId": "5d09741b-1ef3-42e7-80b8-e971fcfba738",
                "folder": true,
                "size": 0,
                "path": null,
                "orderNo": 0,
                "type": 0
            },
            {
                "id": "616979ef-c4b5-47c3-959a-70b13622e3ab",
                "name": "aa",
                "creatorId": "b27f525b-f44f-4519-8bf1-2087382d4f56",
                "creator": "邢专员（行政专员）",
                "createDate": "2017-08-08",
                "lastModifyDate": "2017-08-08",
                "diskId": "45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
                "folderId": "5d09741b-1ef3-42e7-80b8-e971fcfba738",
                "folder": true,
                "size": 0,
                "path":
                "\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\\\cfe92a5b-8fa3-45fd-896b-5ed27365bfe6\\\\5d09741b-1ef3-42e7-80b8-e971fcfba738",
                "orderNo": 0,
                "type": 0
            }
        ],
        "pageCount": 4
    }
}
```



**参数说明：**

| **参数** | **说明**                                                                      |
|----------|-------------------------------------------------------------------------------|
| errcode  | 返回码                                                                        |
| errmsg   | 对返回码的文本描述内容                                                        |
| data     | 返回的对象数据，数据结构参考[File对象](#file文件)或[Folder对象](#folder-目录) |

目录下的文件列表(目录id，文件名)
--------------------------------

查询每个目录下的文件列表。

备注：根目录为网盘的ID

**请求方式：**GET  
**请求地址：**/kms/disks/folders/files?ownerId=:&fileName=:orderByfield=:&orderMode=:pageNo=:&linesPerPage

**参数说明：**

| **参数**       | **必须** | **说明**                              |
|----------------|----------|---------------------------------------|
| ownerId=:      | 否       | 网盘的id或者目录的id                  |
| filename=:     | 否       | 文件名                                |
| orderByfield=: | 否       | 属性名(NAME CREATOR LAST_MODIFY_DATE) |
| orderMode=:    | 否       | 升序(ASC)/降序(DESC)                  |
| pageNo=:       | 是       | 当前页                                |
| linesPerPage=: | 是       | 每页显示条数                          |

当 不传orderByfield和orderMode，默认为以文件的名字升序

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 13,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [
            {
                "id": "4b5cba76-ab97-4f51-ae56-0ad7a45ade2c",
                "name": "default.pdf",
                "creatorId": "11e7-a198-3969df1c-a900-73852bc58bcf",
                "creator": "企业知识管理员",
                "createDate": "2017-09-26",
                "lastModifyDate": "2017-09-26",
                "diskId": "11e7-a198-3969df1c-a900-73852bc58bcf",
                "folderId": "db5cc5de-26f1-42f4-a77a-baddf00729b0",
                "folder": false,
                "size": 0,
                "path":
                "11e7-a198-3969df1c-a900-73852bc58bcf/db5cc5de-26f1-42f4-a77a-baddf00729b0",
                "type": "pdf",
                "url":
                "11e7-a198-3969df1c-a900-73852bc58bcf/201709/4b5cba76-ab97-4f51-ae56-0ad7a45ade2c.pdf",
                "originType": 1,
                "originId": null,
                "views": 2,
                "lastViewDate": "2017-10-27",
                "downloads": 0,
                "lastDownloadDate": null,
                "shares": 0,
                "lastShareDate": null,
                "collects": 0,
                "lastCollectDate": null,
                "good": 0,
                "bad": 0
            },
            {
                "id": "cf0a1cc3-dde6-4b63-b75b-5e0ead601295",
                "name": "md的bug.html",
                "creatorId": "11e7-a198-3969df1c-a900-73852bc58bcf",
                "creator": "企业知识管理员",
                "createDate": "2017-09-26",
                "lastModifyDate": "2017-09-26",
                "diskId": "11e7-a198-3969df1c-a900-73852bc58bcf",
                "folderId": "db5cc5de-26f1-42f4-a77a-baddf00729b0",
                "folder": false,
                "size": 0,
                "path":
                "11e7-a198-3969df1c-a900-73852bc58bcf/db5cc5de-26f1-42f4-a77a-baddf00729b0",
                "type": "html",
                "url":
                "11e7-a198-3969df1c-a900-73852bc58bcf/201709/cf0a1cc3-dde6-4b63-b75b-5e0ead601295.html",
                "originType": 1,
                "originId": null,
                "views": 1,
                "lastViewDate": "2017-11-09",
                "downloads": 0,
                "lastDownloadDate": null,
                "shares": 0,
                "lastShareDate": null,
                "collects": 0,
                "lastCollectDate": null,
                "good": 0,
                "bad": 0
            }
        ],
        "pageCount": 7
    }
}
```



**参数说明：**

| **参数** | **说明**                                                                      |
|----------|-------------------------------------------------------------------------------|
| errcode  | 返回码                                                                        |
| errmsg   | 对返回码的文本描述内容                                                        |
| data     | 返回的对象数据，数据结构参考[File对象](#file文件)或[Folder对象](#folder-目录) |

文件预览
--------

**请求方式：**GET  
**请求地址：**/kms/disks/{diskId}/files/{fileId}/preview

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| diskId   | 是       | 网盘id   |
| fileId   | 是       | 文件id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "url":"\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\201708\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac.pdf",
        "operations":[
            1,
            2]
    }
}

```



**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | PDF文件路径            |

## 手机文件预览(如有水印则返回水印的地址)

**请求方式：**GET  
**请求地址：**/mobile/kms/disks/{diskId}/files/{fileId}/preview

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| diskId   | 是       | 网盘id   |
| fileId   | 是       | 文件id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":"{\"pdfFileUrl\":\"4a2a7704-0cdd-425d-8c51-75f4af062ca2/202007/PDF/d319492a-3252-4bb7-b647-af301406f64e.pdf\",\"message\":null,\"readable\":true,\"fileEntity\":{\"id\":\"d319492a-3252-4bb7-b647-af301406f64e\",\"name\":\"105成都高新区关于加快国际科技金融创新中心建设的若干政策.docx\",\"creatorId\":\"zPsp2hk7CEwtqeMCwtj\",\"creator\":\"管理员\",\"createDate\":1594051200000,\"lastModifyDate\":1594090105000,\"diskId\":\"4a2a7704-0cdd-425d-8c51-75f4af062ca2\",\"folderId\":\"440681f5-641d-482d-973c-0b86e00cf552\",\"folder\":false,\"size\":17526,\"path\":\"4a2a7704-0cdd-425d-8c51-75f4af062ca2/440681f5-641d-482d-973c-0b86e00cf552\",\"type\":\"docx\",\"url\":\"4a2a7704-0cdd-425d-8c51-75f4af062ca2/202007/d319492a-3252-4bb7-b647-af301406f64e.docx\",\"originType\":1,\"originId\":null,\"categorys\":null,\"categorysJson\":[],\"views\":6,\"lastViewDate\":1594093971173,\"downloads\":0,\"lastDownloadDate\":null,\"shares\":0,\"lastShareDate\":null,\"collects\":0,\"lastCollectDate\":null,\"lastEditDate\":null,\"good\":0,\"bad\":0}}"
}


```



**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | PDF文件路径            |

## 

4.3文件收藏
-----------

**请求方式：**PATCH  
**请求地址：**/disks/:diskId /files/:fileId/collect

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :diskId  | 是       | 网盘id   |
| :fileId  | 是       | 文件id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

4.4文件分享
-----------

**请求方式：**PATCH  
**请求地址：**/kms/disks/:diskId/folders /files/:fileId/share

**请求包体：**

```json
[
    "stageId1",
    "stageId2"
]
```

**参数说明：**

| **参数**  | **必须** | **说明**                     |
|-----------|----------|------------------------------|
| :diskId   | 是       | 网盘id                       |
| :folderId | 是       | 目录id                       |
| stageIds  | 是       | 数组 ：{ stageId1，stageId2} |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

4.5文件重命名
-------------

**请求方式：**PATCH  
**请求地址：**/kms/disks/:diskId/files/:fileId/rename

**请求包体：**

```json

{
    "name":"name1"
}
```



**参数说明：**

| **参数**  | **必须** | **说明** |
|-----------|----------|----------|
| :diskId   | 是       | 网盘id   |
| :folderId | 是       | 目录id   |
| :filed    | 是       | 文件id   |
| :name     | 是       | 文件名称 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
        "name":"abc",
        "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
        "creator":"邢专员（行政专员）",
        "createDate":"2017-08-01",
        "lastModifyDate":"2017-08-08",
        "diskId":"45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
        "folderId":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "folder":false,
        "size":12,
        "path":"\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac\\\\cfe92a5b-8fa3-45fd-896b-5ed27365bfe6\\\\5d09741b-1ef3-42e7-80b8-e971fcfba738",
        "type":"txt",
        "url":"\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
        "originType":1,
        "originId":null,
        "views":0,
        "lastViewDate":null,
        "downloads":0,
        "lastDownloadDate":null,
        "shares":0,
        "lastShareDate":null,
        "collects":0,
        "lastCollectDate":null,
        "good":0,
        "bad":0
    }
}

```

**参数说明：**

| **参数** | **说明**                                        |
|----------|-------------------------------------------------|
| errcode  | 返回码                                          |
| errmsg   | 对返回码的文本描述内容                          |
| data     | 返回File对象，数据结构参考[File对象](#file文件) |

4.6单个文件移动
---------------

**请求方式：**PATCH  
**请求地址：**/kms/disks/:diskId/files/:fileId/moveto/folderId/:destfolderId

**参数说明：**

| **参数**       | **必须** | **说明**   |
|----------------|----------|------------|
| :diskId        | 是       | 网盘id     |
| :filed         | 是       | 文件id     |
| : destfolderId | 是       | 目标目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

4.7单个文件下载
---------------

**请求方式：**GET  
**请求地址：/kms/download/：filed**

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :filed   | 是       | 文件id   |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| errcode  | 返回码                            |
| errmsg   | 对返回码的文本描述内容            |
| data     | 返回的视图对象，数据结构参考\#4.2 |

4.8单个文件删除
---------------

**请求方式：**DELETE  
**请求地址：**/kms/disks/:diskId /files/:fileId

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :diskId  | 是       | 网盘id   |
| :filed   | 是       | 文件id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

4.9获取团队阶段树结构
---------------------

**请求方式：**GET  
**请求地址：**/kms/teams/stagesTree

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "name":"一级目1_3",
            "id":"1cbf5e54-ce72-4199-89a0-cb792f120fde"
        },
        {
            "name":"一级目1_1",
            "id":"5d09741b-1ef3-42e7-80b8-e971fcfba738",
            "childern":[
                {
                    "name":"二级1_1_2_2"
                },
                {
                    "name":"二级目1_1_2_3",
                    "id":"81964e30-f7ad-4fa0-9ec4-2660dcc92744"
                }
            ]
        },
        {
            "name":"新建文件夹",
            "id":"fe8f5c12-8f17-4eac-9f58-e01821f23a0c"
        }]
}

```



**参数说明：**

| **参数** | **说明**               |
|----------|------------------------|
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     |                        |

4.10文件收藏（指定文件夹）
--------------------------

**请求方式：**PATCH  
**请求地址：**/disks/:diskId /files/:fileId/collect/folder/:folderId

**参数说明：**

| **参数**  | **必须** | **说明**   |
|-----------|----------|------------|
| :diskId   | 是       | 网盘id     |
| :fileId   | 是       | 文件id     |
| :folderId | 是       | 收藏目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |
|          |                              |

4.11 获取文件数量
-----------------

**请求方式：GET**  
**请求地址：**/kms/files/count

**参数说明：**

无。

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |
|          |                              |

4.12 文件查询(首页高级搜索)
---------------------------

**请求方式：GET**  
**请求地址：**/kms/files?fileName={fileName}&userIds={userIds}&beginTime={beginTime}&endTime={endTime}&linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**

| **参数**     | **必须** | **说明**         |
|--------------|----------|------------------|
| fileName     | 否       | 文件名称         |
| userIds      | 否       | 用户id集合       |
| beginTime    | 否       | 创建时间(毫秒值) |
| endTime      | 否       | 结束时间(毫秒值) |
| linesPerPage | 否       | 每页条数         |
| pageNo       | 否       | 页数             |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 6,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [
            {
                "id": "8bdf7853-4056-48cd-901d-2d53dc7b8561",
                "name": "授权sql.txt",
                "creatorId": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "creator": "admin1",
                "createDate": "2019-07-11",
                "lastModifyDate": "2019-07-11",
                "diskId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "folderId": "95068913-915f-4ca2-a1bb-6a7741d6b761",
                "folder": false,
                "size": 1262,
                "path":
                "null/dfdf77eb-2a18-4250-99aa-12686be663a7/4161ea88-ed6c-490b-a261-130cd8793f4f/95068913-915f-4ca2-a1bb-6a7741d6b761",
                "permission": null,
                "type": "txt",
                "url":
                "dfdf77eb-2a18-4250-99aa-12686be663a7/201907/8bdf7853-4056-48cd-901d-2d53dc7b8561.txt",
                "originType": 1,
                "originId": null,
                "views": 0,
                "lastViewDate": null,
                "downloads": 0,
                "lastDownloadDate": null,
                "shares": 0,
                "lastShareDate": null,
                "collects": 0,
                "lastCollectDate": null,
                "good": 0,
                "bad": 0
            },
            {
                "id": "4b08a9a4-be99-4705-aca4-66f377ba25ea",
                "name": "werty.doc",
                "creatorId": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "creator": "admin1",
                "createDate": "2019-07-10",
                "lastModifyDate": "2019-07-10",
                "diskId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "folderId": "756e06ff-bce6-4f5a-8d3f-ae38f4198719",
                "folder": false,
                "size": 10240,
                "path":
                "null/dfdf77eb-2a18-4250-99aa-12686be663a7/4161ea88-ed6c-490b-a261-130cd8793f4f/756e06ff-bce6-4f5a-8d3f-ae38f4198719",
                "permission": null,
                "type": "doc",
                "url":
                "dfdf77eb-2a18-4250-99aa-12686be663a7/201907/4b08a9a4-be99-4705-aca4-66f377ba25ea.doc",
                "originType": 1,
                "originId": null,
                "views": 0,
                "lastViewDate": null,
                "downloads": 0,
                "lastDownloadDate": null,
                "shares": 0,
                "lastShareDate": null,
                "collects": 0,
                "lastCollectDate": null,
                "good": 0,
                "bad": 0
            }],
        "from": null,
        "pageCount": 3
    }
}

```



**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |
|          |                              |

## 4.13 获取用户的文件上传数量

**请求方式：GET**  
**请求地址：**/kms/files/userUploadFileCount?originType={originType}

**参数说明：**

| **参数**   | **必须** | **说明**     |
| ---------- | -------- | ------------ |
| originType | 否       | 文件来源类型 |

无。

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":count
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回数量               |
|          |                        |

## 4.14 获取所有用户的文件上传数量

**请求方式：GET**  
**请求地址：**/kms/files/getAllUserUploadFileCount?linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**

| **参数**     | **必须** | **说明** |
| ------------ | -------- | -------- |
| linesPerPage | 是       | 行数     |
| pageNo       | 是       | 页码     |

无。

**权限说明：**

无。

**返回结果：**

```json
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 2,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"count": 3,
			"name": "sam01",
			"avatar": null
		}, {
			"count": 1,
			"name": "胡坚锐",
			"avatar": null
		}],
		"pageCount": 1
	}
}
```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 返回数据               |
|          |                        |

## 批量操作（同时操作目录和文件）

## 多个FileObj移动

**请求方式：**PATCH  
**请求地址：**/disks/:diskId/fileobjs/moveto/folders/:folderId

**请求包体：**

```json
[
    {
        "fileObjectId": "",
        "isFolder": true
    }
]

```

**参数说明：**

| **参数**  | **必须** | **说明**     |
|-----------|----------|--------------|
| :diskId   | 是       | 网盘id       |
| :folderId | 是       | 移动到目录id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

多个FileObj删除
---------------

**请求方式：**DELETE  
**请求地址：**/disks/:diskId/fileObjs

**请求包体：**

```json
[
    {
        "fileObjectId": "fileId",
        "isFolder": true
    }
]

```



**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :diskId  | 是       | 网盘id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

多个FileObj下载
---------------

>   服务器返回文档的催办信息。

**请求方式：**GET  
**请求地址：/kms/downloads?folderIds={folderIds}&fileIds={fileIds}**

**参数说明：**

| **参数**  | **必须** | **说明**                     |
|-----------|----------|------------------------------|
| folderIds | 是       | 目录id,可同时有多个相同参数  |
| fileIds   | 是       | 文件id，可同时有多个相同参数 |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                           |
|----------|----------------------------------------------------|
| errcode  | 返回码                                             |
| errmsg   | 对返回码的文本描述内容                             |
| data     | 返回的表单对象，数据结构参考[\#3.3](#取消目录置顶) |

# 搜索模块

## 文件搜索列表

>   根据关键字查询文件索引列表

**请求方式：**GET  
**请求地址：**/kms/search/files?keyWord={keyWord}&selectTitle=true&selectContent=true&creator={creator}&beginTime={beginTime}&endTime={endTime}&fileTypes={fileTypes}&categoryIds={categoryIds}&scope={scope}&pageNo={pageNo}&linesPerPage={linesPerPage}

**参数说明：**

| 参数          | 含义                                | 必须 |
| ------------- | ----------------------------------- | ---- |
| keyWord       | 关键词                              | 是   |
| selectTitle   | 标题是否搜索-true/false             | 否   |
| selectContent | 内容是否搜索-true/false             | 否   |
| creator       | 创建人                              | 否   |
| beginTime     | 时间范围-开始时间-毫秒值            | 否   |
| endTime       | 时间范围-结束时间-毫秒值            | 否   |
| fileTypes     | 文件类型-doc/docx/ppt/pptx/xls/xlsx | 否   |
| categoryIds   | 标签id集合                          | 否   |
| scope         | 区域                                | 是   |
| pageNo        | 页数                                | 是   |
| linesPerPage  | 每页显示数量                        | 是   |

**权限说明：**

无。

**返回结果：**

```json
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"rowCount": 1,
		"linesPerPage": 10,
		"pageNo": 1,
		"datas": [{
			"id": "a5133813-54f9-45ac-bed0-3bb6c96d137f",
			"name": "2018.1.19信息参阅第18期人行道<span style='color:red;'>建设</span>与治理专刊 (1).doc",
			"creatorId": "zPsp2hk7CEwtqeMCwtj",
			"creator": "管理员",
			"createDate": "2020-06-08",
			"lastModifyDate": "2020-06-08",
			"diskId": "0dd1e1c1-b5dd-41f4-8e3e-c0479448faf9",
			"folderId": "a56f8f78-52b4-44ef-af2e-fe4136974500",
			"folder": false,
			"size": 98586,
			"path": "0dd1e1c1-b5dd-41f4-8e3e-c0479448faf9/a56f8f78-52b4-44ef-af2e-fe4136974500",
			"type": "doc",
			"url": "0dd1e1c1-b5dd-41f4-8e3e-c0479448faf9/202006/a5133813-54f9-45ac-bed0-3bb6c96d137f.doc",
			"originType": 1,
			"originId": null,
			"categorys": null,
			"categorysJson": [{
				"isAuto": true,
				"categoryName": "2",
				"categoryId": "4e8278fe-df5d-4542-b044-5f9673fd5d4a",
				"fileId": "a5133813-54f9-45ac-bed0-3bb6c96d137f"
			}, {
				"isAuto": false,
				"categoryName": "素质",
				"categoryId": "61b0c95e-9660-4b6b-9d87-d217c132562b",
				"fileId": "a5133813-54f9-45ac-bed0-3bb6c96d137f"
			}, {
				"isAuto": false,
				"categoryName": "天河区",
				"categoryId": "52ec8721-c5a5-475f-b3dc-208a228765c8",
				"fileId": "a5133813-54f9-45ac-bed0-3bb6c96d137f"
			}, {
				"isAuto": false,
				"categoryName": "审核意见",
				"categoryId": "90fedf5e-fb65-4b9b-ab63-ecab39c7e61a",
				"fileId": "a5133813-54f9-45ac-bed0-3bb6c96d137f"
			}, {
				"isAuto": false,
				"categoryName": "广州市",
				"categoryId": "d0afdbdc-ea28-4dd1-b3e8-54a14e2e0071",
				"fileId": "a5133813-54f9-45ac-bed0-3bb6c96d137f"
			}],
			"views": 0,
			"lastViewDate": null,
			"downloads": 0,
			"lastDownloadDate": null,
			"shares": 0,
			"lastShareDate": null,
			"collects": 0,
			"lastCollectDate": null,
			"lastEditDate": null,
			"good": 0,
			"bad": 0,
			"fileType": "doc",
			"content": "<abc style='color:red;'>建设</abc>",
			"resourceType": "1",
			"pageCount": "17",
			"folderName": "bb"
		}],
		"pageCount": 1
	}
}

```

**参数说明：**

| **参数** | **说明**                                                           |
|----------|--------------------------------------------------------------------|
| errcode  | 返回码                                                             |
| errmsg   | 对返回码的文本描述内容                                             |
| data     | 返回的对象数据，数据结构参考[Search File对象](#searchfile查询文件) |

最新浏览文件列表
----------------

>   服务器返回文档的催办信息。

**请求方式：**GET  
**请求地址：**/kms/search/files/lastest_view?pageNo=:pageno&linesPerPage
=:linesperpage

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| :pageno       | 是       | 当前页   |
| :linesperpage | 是       | 每页条数 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 33,
        "linesPerPage": 5,
        "pageNo": 1,
        "datas": [
            {
                "id": "4d8ee020-7f2d-4490-9adf-a654a6e45d7e",
                "name": "江苏省邮电规划设计院知识管理系统需求文档V4.0.docx",
                "creatorId": "11e6-5fac-d126bfe2-a02a-b789a6ff0217",
                "creator": "康妮",
                "createDate": "2017-08-09",
                "lastModifyDate": null,
                "diskId": "45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
                "folderId": "cfe92a5b-8fa3-45fd-896b-5ed27365bfe6",
                "folder": false,
                "size": 7514142,
                "path":
                "\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac/cfe92a5b-8fa3-45fd-896b-5ed27365bfe6",
                "type": "docx",
                "url":
                "45e196e4-cdc7-4911-b1a0-0eab8cff2aac/201708/4d8ee020-7f2d-4490-9adf-a654a6e45d7e.docx",
                "originType": 0,
                "originId": null,
                "views": 0,
                "lastViewDate": null,
                "downloads": 0,
                "lastDownloadDate": null,
                "shares": 0,
                "lastShareDate": null,
                "collects": 0,
                "lastCollectDate": null,
                "good": 0,
                "bad": 0
            }
        ],
        "pageCount": 7
    }
}

```



**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[File对象](#file文件) |

最新分享文件列表
----------------

>   服务器返回文档的催办信息。

**请求方式：**GET  
**请求地址：**/kms/search/files/lastest_share?pageNo=:pageno&linesPerPage

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| :pageno       | 是       | 当前页   |
| :linesperpage | 是       | 每页条数 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 33,
        "linesPerPage": 5,
        "pageNo": 1,
        "datas": [
            {
                "id": "4d8ee020-7f2d-4490-9adf-a654a6e45d7e",
                "name": "江苏省邮电规划设计院知识管理系统需求文档V4.0.docx",
                "creatorId": "11e6-5fac-d126bfe2-a02a-b789a6ff0217",
                "creator": "康妮",
                "createDate": "2017-08-09",
                "lastModifyDate": null,
                "diskId": "45e196e4-cdc7-4911-b1a0-0eab8cff2aac",
                "folderId": "cfe92a5b-8fa3-45fd-896b-5ed27365bfe6",
                "folder": false,
                "size": 7514142,
                "path":
                "\\\\45e196e4-cdc7-4911-b1a0-0eab8cff2aac/cfe92a5b-8fa3-45fd-896b-5ed27365bfe6",
                "type": "docx",
                "url":
                "45e196e4-cdc7-4911-b1a0-0eab8cff2aac/201708/4d8ee020-7f2d-4490-9adf-a654a6e45d7e.docx",
                "originType": 0,
                "originId": null,
                "views": 0,
                "lastViewDate": null,
                "downloads": 0,
                "lastDownloadDate": null,
                "shares": 0,
                "lastShareDate": null,
                "collects": 0,
                "lastCollectDate": null,
                "good": 0,
                "bad": 0
            }
        ],
        "pageCount": 7
    }
}

```



**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[File对象](#file文件) |

关键词搜索列表
--------------

>   服务器返回文档的催办信息。

**请求方式：**GET  
**请求地址：**/kms/search/files/lastest_search?pageNo=:pageno&linesPerPage

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| :pageno       | 是       | 当前页   |
| :linesperpage | 是       | 每页条数 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "rowCount":1,
        "linesPerPage":5,
        "pageNo":1,
        "datas":[
            {
                "id":"11e6-5fac-d126bfe2-a02a-b789a6ff0266",
                "content":"阿里巴巴",
                "creatorId":"11e6-5fac-d126bfe2-a02a-b789a6ff0217",
                "creator":"康妮",
                "createDate":"2017-08-11"
            }
        ],
        "pageCount":1
    }
}

```



**参数说明：**

| **参数** | **说明**                                             |
|----------|------------------------------------------------------|
| errcode  | 返回码                                               |
| errmsg   | 对返回码的文本描述内容                               |
| data     | 返回的表单对象，数据结构参考[KeyWord对象](#file文件) |

1.  授权（Authorization）

    1.  获取文件授权列表

**请求方式：**GET  
**请求地址：**/kms/resources/{resourceId}/authorizations

**参数说明：**

| **参数**      | **必须** | **说明** |
|---------------|----------|----------|
| {resourceId}  | 是       | 资源ID   |
| :pageno       | 是       | 当前页   |
| :linesperpage | 是       | 每页条数 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "rowCount":1,
        "linesPerPage":1,
        "pageNo":1,
        "datas":[
            {
                "id":"bffc027c-cc2f-461d-82bc-60502bdc167f",
                "description":"技术研发部_一级目录1_1.txt",
                "scope":1,
                "targetId":[
                    "11e7-7045-31a4aecf-85f9-cbfc8973e987"],
                "targetName":"Oliver",
                "startDate":"2017-08-16",
                "endDate":"2017-08-16",
                "creatorId":"11e7-80be-f5cbdfaa-8e11-e7a531ef9423",
                "creator":"Annie",
                "createDate":"2017-08-16",
                "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
                "resourceType":1,
                "operations":[
                    "1",
                    "2"]
            }],
        "pageCount":1
    }
}

```



**参数说明：**

| **参数** | **说明**                                                            |
|----------|---------------------------------------------------------------------|
| errcode  | 返回码                                                              |
| errmsg   | 对返回码的文本描述内容                                              |
| data     | 返回的表单对象，数据结构参考[Authorization对象](#authorization授权) |

创建授权信息
------------

**请求方式：**POST  
**请求地址：**/kms/resources/{resourceId}/authorizations

**请求包体：**

```json
{
    "description":"技术研发部_一级目录1_1.txt",
    "scope":1,
    "targetId":[
        "11e7-7045-31a4aecf-85f9-cbfc8973e987"],
    "targetName":"Oliver",
    "startDate":1502953873385,
    "endDate":1502953873385,
    "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
    "resourceType":1,
    "operations":[
        "1",
        "2"]
}

```



**参数说明：**

| **参数**     | **必须** | **说明**                         |
|--------------|----------|----------------------------------|
| {resourceId} | 是       | 资源ID                           |
| description  | 是       | 资源名称                         |
| scope        | 是       | 授权范围                         |
| targetId     | 是       | 用户ID数组                       |
| targetName   | 是       | 数组对应的用户名，仅用于前台回显 |
| startDate    | 是       | 起始时间                         |
| endDate      | 是       | 结束时间                         |
| resourceId   | 是       | 资源ID                           |
| resourceType | 是       | 资源类型                         |
| operations   | 是       | 授权权限                         |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"15c87e9e-9123-4191-add8-fa7a4c070dc0",
        "description":"技术研发部_一级目录1_1.txt",
        "scope":1,
        "targetId":[
            "11e7-7045-31a4aecf-85f9-cbfc8973e987"],
        "targetName":"Oliver",
        "startDate":1502882808693,
        "endDate":1502882808693,
        "creatorId":"11e7-80be-f5cbdfaa-8e11-e7a531ef9423",
        "creator":"Annie",
        "createDate":1502882808693,
        "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
        "resourceType":1,
        "operations":[
            "1",
            "2"]
    }
}

```



**参数说明：**

| **参数** | **说明**                                                            |
|----------|---------------------------------------------------------------------|
| errcode  | 返回码                                                              |
| errmsg   | 对返回码的文本描述内容                                              |
| data     | 返回的表单对象，数据结构参考[Authorization对象](#authorization授权) |

更新授权信息
------------

**请求方式：PUT**  
**请求地址：**/kms/resources/{resourceId}/authorizations/{authorizations }

请求包体：

```json
{
    "id":"15c87e9e-9123-4191-add8-fa7a4c070dc0",
    "description":"技术研发部_一级目录1_1.txt",
    "scope":1,
    "targetId":[
        "11e7-7045-31a4aecf-85f9-cbfc8973e987"],
    "targetName":"Oliver",
    "startDate":1502882808693,
    "endDate":1502882808693,
    "creatorId":"11e7-80be-f5cbdfaa-8e11-e7a531ef9423",
    "creator":"Annie",
    "createDate":1502882808693,
    "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
    "resourceType":1,
    "operations":[
        "1",
        "2"]
}

```



**参数说明：**

| **参数**          | **必须** | **说明** |
|-------------------|----------|----------|
| {resourceId}      | 是       | 资源ID   |
| { authorizations} | 是       | 权限ID   |
| 请求包体          | 是       | 权限数据 |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "id":"15c87e9e-9123-4191-add8-fa7a4c070dc0",
        "description":"技术研发部_一级目录1_1.txt",
        "scope":1,
        "targetId":[
            "11e7-7045-31a4aecf-85f9-cbfc8973e987"],
        "targetName":"Oliver",
        "startDate":1502882808693,
        "endDate":1502882808693,
        "creatorId":"11e7-80be-f5cbdfaa-8e11-e7a531ef9423",
        "creator":"Annie",
        "createDate":1502882808693,
        "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
        "resourceType":1,
        "operations":[
            "1",
            "2"]
    }
}

```



**参数说明：**

| **参数** | **说明**                                                            |
|----------|---------------------------------------------------------------------|
| errcode  | 返回码                                                              |
| errmsg   | 对返回码的文本描述内容                                              |
| data     | 返回的表单对象，数据结构参考[Authorization对象](#authorization授权) |

删除授权信息
------------

**请求方式：**DELETE  
**请求地址：**kms/authorizations

**请求包体：**

```
[
    "authorizationId1",
    "authorizationId2"
]
```



**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 对返回码的文本描述内容       |
| data     | 返回操作是否成功，true/false |

# 团队（Teams）

## 获取团队编号

**请求方式：GET**  
**请求地址：**/kms/teams/serialNumber

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{"errcode":0,"errmsg":"ok","data":"20170823002"}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

创建团队
--------

创建团队（请求包体）

**请求方式：POST**  
**请求地址：**/kms/teams

**请求包体：**

```json
{
    "name":"teamName",
    "description":"description",
    "serialNumber":"20170823002",
    "deptPermission":[
        "download",
        "preview"],
    "compPermission":[
        "download",
        "preview"],
    "members":[
        {
            "name":"userName",
            "type":1,
            "userId":"userId"
        },
        {
            "name":"userName",
            "type":0,
            "userId":"userId"
        }
    ]
}

```



**参数说明：**

类型是管理员传数字1,类型是普通成员传数字0

部门预览：preview 部门下载：download 公司预览：preview 公司下载：download

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "1c43e748-2edb-4b8e-84bd-b46adaac8263",
        "name": "c++222",
        "serialNumber": "20170821001",
        "description": "desc",
        "creatorId": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
        "creator": "Oliver",
        "createDate": 1503298639088,
        "members": [
            {
                "id": "c6f7f43d-dabb-40f5-a5ad-cf7f38545fad",
                "name": "用户名1",
                "type": 0,
                "teamId": "1c43e748-2edb-4b8e-84bd-b46adaac8263",
                "userId": "用户id1"
            },
            {
                "id": "4a8faedd-7664-4f36-b2d5-2c1d44e4a4d7",
                "name": "用户名2",
                "type": 1,
                "teamId": "1c43e748-2edb-4b8e-84bd-b46adaac8263",
                "userId": "用户id2"
            }
        ],
        "stages": [
        ],
        "deptPermission": [
            "download",
            "preview"
        ],
        "compPermission": [
            "download",
            "preview"
        ],
        "diskId": "3a5d55bf-6d5e-45f0-8fee-1f5bba8e0b3a"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

更新团队
--------

更新团队（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/teams/:teamId

**请求包体：**

```json
{
    "teamId":"teamId",
    "name":"teamName",
    "description":"description",
    "serialNumber":"20170823002",
    "deptPermission":[
        "download",
        "preview"],
    "compPermission":[
        "download",
        "preview"],
    "members":[
        {
            "name":"userName",
            "type":0,
            "teamId":"teamId",
            "userId":"userId"
        },
        {
            "name":"userName",
            "type":1,
            "teamId":"teamId",
            "userId":"userId"
        }
    ]
}

```



**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :teamId  | 是       | 团队id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "57d9e050-d68f-462e-af32-117ed16ee963",
        "name": "团队名称2",
        "serialNumber": "20170809001",
        "description": "第2次修改",
        "creatorId": "b27f525b-f44f-4519-8bf1-2087382d4f56",
        "creator": "邢专员（行政专员）",
        "createDate": 1502236800000,
        "members": [
            {
                "id": "6e5cf85f-a3ad-4db5-ad2b-88ddbcf36b0f",
                "name": "邢专员（行政专员）",
                "type": 1,
                "teamId": "57d9e050-d68f-462e-af32-117ed16ee963",
                "userId": "b27f525b-f44f-4519-8bf1-2087382d4f56"
            }
        ],
        "stages": [
            {
                "id": "c67c5eb2-89c4-4643-818c-0831f5d82edf",
                "name": "基础数据初始阶段",
                "teamId": "57d9e050-d68f-462e-af32-117ed16ee963",
                "folderId": "1eb0dc00-4154-4dd5-8a2b-855af65a160c",
                "comments": "[]",
                "orderNo": 0,
                "commentList": [
                    {
                        "id": "b29a648f-0374-4604-b224-6826d2f74736",
                        "content": "基础数据评论1",
                        "creatorId": "b27f525b-f44f-4519-8bf1-2087382d4f56",
                        "creator": "邢专员（行政专员）",
                        "createDate": 1502249111318
                    }
                ]
            },
            {
                "id": "efc48775-d05a-426e-9f00-048fe27d4964",
                "name": "基础数据中级阶段",
                "teamId": "57d9e050-d68f-462e-af32-117ed16ee963",
                "folderId": "3511315c-a049-4dee-b065-d52cd9b1acb4",
                "comments": null,
                "orderNo": 0,
                "commentList": [
                ]
            }
        ],
        "deptPermission": [
            "download",
            "preview"
        ],
        "compPermission": null,
        "diskId": "9679acdd-81b7-4091-adee-f2754d91e6b9"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

删除团队（单个/多个）
---------------------

删除团队（请求包体）

**请求方式：DELETE**  
**请求地址：**/kms/teams

**请求包体：**

```json
["teamId1","teamId2"]
```



**参数说明：**

复选框选多个或单个，传多个teamId的集合到后台

**权限说明：**

企业管理员、团队下的成员，团队的管理员才可以删除团队

**返回结果：**

有权限

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

无权限

```
{"errcode":401,"errmsg":"没有删除[XXX团队名称]的权限"}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询团队
--------

查询团队

**请求方式：GET**  
**请求地址：**/kms/teams/?isMyTeams=: & serialNumber=: & creator=:&
departmentId=:&teamName=: &beginTime=: &endTime=: &linesPerPage=: &pageNo=:

**参数说明：**

| **参数**      | **必须** | **说明**                                   |
|---------------|----------|--------------------------------------------|
| :isMyTeams    | 是       | True/false,是否点了我参与的团队，为空时""  |
| :serialNumber | 否       | 查询时，用户是否有填编号,为空时""          |
| :creator      | 否       | 查询时，用户是否有填创建者，为空时""       |
| :departmentId | 否       | 查询时，用户是否有填部门(部门id), 为空时"" |
| :teamName     | 否       | 查询时，用户是否有填团队名称, 为空时""     |
| :beginTime    | 否       | 查询时，用户是否有时间范围, 为空时""       |
| :endTime      | 否       | 查询时，用户是否有时间范围, 为空时""       |
| :linesPerPage | 是       | 每页显示的条数                             |
| :pageNo       | 是       | 第几页                                     |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "rowCount":1,
        "linesPerPage":15,
        "pageNo":1,
        "datas":[
            {
                "id":"416c5d1c-35f1-4a07-aedf-7fc3f6239f57",
                "name":"技术支持组",
                "serialNumber":"20200615001",
                "description":"技术支持组",
                "creatorId":"qxtJKvUApXkqDWUHWt2",
                "creator":"陈小聪",
                "createDate":"2020-06-15",
                "members":[
                    {
                        "id":"2fe4e6eb-b5fd-4a95-bb7c-41e83771ea47",
                        "name":"陈小聪",
                        "type":1,
                        "teamId":"416c5d1c-35f1-4a07-aedf-7fc3f6239f57",
                        "userId":"qxtJKvUApXkqDWUHWt2"
                    }],
                "stages":[
                ],
                "deptPermission":[
                    "preview",
                    "download"],
                "compPermission":[
                    "preview"],
                "diskId":"416c5d1c-35f1-4a07-aedf-7fc3f6239f57",
                "subscription":false
            }],
        "pageCount":1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

团队下的成员
------------

团队下的阶段

**请求方式：GET**  
**请求地址：**/kms/teams/:teamId/members

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :teamId  | 是       | 团队id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "6e5cf85f-a3ad-4db5-ad2b-88ddbcf36b0f",
            "name": "邢专员（行政专员）",
            "type": 49,
            "teamId": "57d9e050-d68f-462e-af32-117ed16ee963",
            "userId": "b27f525b-f44f-4519-8bf1-2087382d4f56"
        }
    ]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

获取指定团队
------------

**请求方式：GET**  
**请求地址：**/kms/teams/:teamId

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :teamId  | 是       | 团队id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "1c43e748-2edb-4b8e-84bd-b46adaac8263",
        "name": "c++222",
        "serialNumber": "20170821001",
        "description": "desc",
        "creatorId": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
        "creator": "Oliver",
        "createDate": 1503298639088,
        "members": [
            {
                "id": "c6f7f43d-dabb-40f5-a5ad-cf7f38545fad",
                "name": "用户名1",
                "type": 0,
                "teamId": "1c43e748-2edb-4b8e-84bd-b46adaac8263",
                "userId": "用户id1"
            },
            {
                "id": "4a8faedd-7664-4f36-b2d5-2c1d44e4a4d7",
                "name": "用户名2",
                "type": 1,
                "teamId": "1c43e748-2edb-4b8e-84bd-b46adaac8263",
                "userId": "用户id2"
            }
        ],
        "stages": [
        ],
        "deptPermission": [
            "download",
            "preview"
        ],
        "compPermission": [
            "download",
            "preview"
        ],
        "diskId": "3a5d55bf-6d5e-45f0-8fee-1f5bba8e0b3a"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

 申请加入团队
-------------

**请求方式：POST**  
**请求地址：**/kms/teams/{teamId}/member

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| teamId   | 是       | 团队id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "514606c3-d10d-44ac-b9af-80229422433d",
        "name": "user3",
        "type": 0,
        "teamId": "746122f8-3bd9-4b9d-852d-f0bb12b40e82",
        "userId": "11e9-a221-c98ca9ad-a6b6-d110b71dd060"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

根据团队id获取团队管理员用户
----------------------------

**请求方式：GET**  
**请求地址：**/kms/team/applications/approvers?teamId={teamId}

**参数说明：**

teamId 团队id

| **参数** | **说明** |
|----------|----------|
| teamId   | 团队id   |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
            "name": "admin1",
            "nameLetter": "admin1",
            "loginno": "admin1",
            "email": "",
            "telephone": "",
            "avatar": "",
            "favoriteContacts": "",
            "superior": null,
            "roles": [
                {
                    "id": "0100",
                    "name": "企业知识管理员",
                    "levels": 100
                },
                {
                    "id": "0020",
                    "name": "专委会知识管理员",
                    "levels": 20
                },
                {
                    "id": "0010",
                    "name": "部门知识管理员",
                    "levels": 10
                },
                {
                    "id": "0001",
                    "name": "员工",
                    "levels": 0
                }],
            "domainid": "11e9-97b6-a4b1ac2a-bb3a-9339eb852df7",
            "defaultDepartment": "11e9-97b7-4caa76d1-bb3a-9339eb852df7",
            "calendarType": "11e9-97b6-a4c1d8d4-bb3a-9339eb852df7",
            "status": 1,
            "level": 0
        }]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 阶段（Stages）

## 团队下的阶段

团队下的阶段

**请求方式：GET**  
**请求地址：**/kms/teams/{teamId}/stages

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :teamId  | 是       | 团队id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":[
        {
            "id":"7e9559f9-368e-490f-8937-a3c811d29f18",
            "name":"aa",
            "teamId":"416c5d1c-35f1-4a07-aedf-7fc3f6239f57",
            "folderId":"4595c0f9-6320-4d13-ab59-f5ffc88481a1",
            "comments":null,
            "orderNo":33,
            "createDate":"2020-06-15",
            "commentList":[
            ]
        },
        {
            "id":"17bc2564-06c5-4885-9e65-1b921a071e8c",
            "name":"bb",
            "teamId":"416c5d1c-35f1-4a07-aedf-7fc3f6239f57",
            "folderId":"442c9b94-1770-4dd8-b18c-65de3936bf2a",
            "comments":null,
            "orderNo":44,
            "createDate":"2020-06-15",
            "commentList":[
            ]
        }]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

团队下的一个阶段
----------------

得到团队下的一个阶段

**请求方式：GET**  
**请求地址：**/kms/stages/{stageId}

**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :staged  | 是       | 阶段id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "id":"7e9559f9-368e-490f-8937-a3c811d29f18",
        "name":"aa",
        "teamId":"416c5d1c-35f1-4a07-aedf-7fc3f6239f57",
        "folderId":"4595c0f9-6320-4d13-ab59-f5ffc88481a1",
        "comments":null,
        "orderNo":33,
        "createDate":"2020-06-15",
        "commentList":[
        ]
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

创建阶段
--------

创建阶段（请求包体）

**请求方式：POST**  
**请求地址：**/kms/stages

**请求包体：**

```json
{
    "name":"stageName",
    "teamId":"teamId",
    "orderNo":2
}

```



**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :teamId  | 是       | 团队id   |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "af902b84-eb87-42b8-9921-dbf590bd6227",
        "name": "阶段一",
        "teamId": "57d9e050-d68f-462e-af32-117ed16ee963",
        "folderId": "a935893b-48e1-4a13-823a-5909db47b4d6",
        "comments": null,
        "orderNo": 0,
        "commentList": [
        ]
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

编辑阶段
--------

编辑阶段（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/stages

**请求包体：**

```json
{
    "id": "阶段id",
    "name": "阶段名称"
}

```



**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "2559cea4-01b2-45ea-a852-0770745cd450",
        "name": "我要更改名称8.25",
        "teamId": "e4fb76a6-6bf7-4ad4-9f46-869312ccc9d2",
        "folderId": "33d34551-35ed-4de3-bb8f-45f2863460ed",
        "comments": "[]",
        "orderNo": 0,
        "commentList": [
        ]
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

删除多个阶段（单个/多个）
-------------------------

删除阶段

**请求方式：DELETE**  
**请求地址：** /kms/stages

**请求包体：**

```json
["stageId1","stageId2"]
```



**参数说明：**

复选框选多个或单个，传多个stageId数组的集合到后台

**权限说明：**

企业管理员、团队创建者、团队的管理员才可以删除阶段

**返回结果：**

有权限

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

无权限

```json
{"errcode":401,"errmsg":"没有删除[基础数据初始阶段]的阶段权限"}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

创建评论
--------

创建评论（请求包体）

**请求方式：POST**  
**请求地址：** /stages/:stageId/comments

**请求包体：**

```json
{
    "content":"评论内容"
}

```



**参数说明：**

| **参数** | **必须** | **说明** |
|----------|----------|----------|
| :stageId | 是       | 阶段id   |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

删除评论
--------

删除评论

**请求方式：DELETE**  
**请求地址：** /stages/{stageId}/comments/:commentId

**参数说明：**

| **参数**   | **必须** | **说明** |
|------------|----------|----------|
| :stageId   | 是       | 阶段id   |
| :commentId | 是       | 评论id   |

**权限说明：**

企业管理员，自己创建的评论,团队创建者，团队的管理员才可以删除评论

无权限，报401错误

**返回结果：**

有权限：

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

无权限：

```json
{"errcode":401,"errmsg":"你没有删除评论的权限"}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 部门（Department）

## 企业域下部门集合

查询目前用户所属的企业域下的部门集合

**请求方式：GET**  
**请求地址：**/kms/departments

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-7045-1c91a1dc-85f9-cbfc8973e987",
            "name": "江苏省邮电规划设计院",
            "parentId": null,
            "children": [
                {
                    "id": "11e7-7045-2da34ac9-85f9-cbfc8973e231",
                    "name": "技术研发部",
                    "parentId": "11e7-7045-1c91a1dc-85f9-cbfc8973e987",
                    "children": [
                    ],
                    "leaf": true
                },
                {
                    "id": "11e7-7045-2da34ac9-85f9-cbfc8973e987",
                    "name": "测试数据",
                    "parentId": "11e7-7045-1c91a1dc-85f9-cbfc8973e987",
                    "children": [
                    ],
                    "leaf": true
                }
            ],
            "leaf": false
        }
    ]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 用户（Users）

## 获取当前用户

**请求方式：GET**  
**请求地址：**/kms/users/myprofile

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
        "name": "Oliver",
        "nameLetter": "Oliver",
        "loginno": "oliver",
        "email": "",
        "telephone": "",
        "avatar": null,
        "favoriteContacts": "",
        "superior": "",
        "roles": [
        ],
        "domainid": "11e7-7045-1c856cdb-85f9-cbfc8973e987",
        "defaultDepartment": "11e7-7045-2da34ac9-85f9-cbfc8973e987",
        "calendarType": "11e7-7045-1c9a7b7d-85f9-cbfc8973e987",
        "status": 1,
        "level": 0
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

获取用户
--------

**请求方式：GET**  
**请求地址：**/kms/users/:id

**参数说明：**

| **参数** | **说明** |
|----------|----------|
| :id      | 用户id   |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
        "name": "Oliver",
        "nameLetter": "Oliver",
        "loginno": "oliver",
        "email": "",
        "telephone": "",
        "avatar": "",
        "favoriteContacts": "",
        "superior": null,
        "roles": [
        ],
        "domainid": "11e7-7045-1c856cdb-85f9-cbfc8973e987",
        "defaultDepartment": "11e7-7045-2da34ac9-85f9-cbfc8973e987",
        "calendarType": "11e7-7045-1c9a7b7d-85f9-cbfc8973e987",
        "status": 1,
        "level": 0
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

获取以部门为树形结构的用户集合
------------------------------

**请求方式：GET**  
**请求地址：**/kms/users/selectbox/departments/{departmentId}

**参数说明：**

| **参数**     | **说明** |
|--------------|----------|
| departmentId | 部门id   |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "11e7-80be-f5cbdfaa-8e11-e7a531ef9423",
            "name": "康妮",
            "type": 1,
            "mobile": "",
            "mobile2": "",
            "email": "",
            "avatar": "",
            "dept": "测试数据",
            "deptId": null,
            "loginNo": "annie",
            "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
        },
        {
            "id": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
            "name": "Oliver",
            "type": 1,
            "mobile": "",
            "mobile2": "",
            "email": "",
            "avatar": "",
            "dept": "测试数据",
            "deptId": null,
            "loginNo": "oliver",
            "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
        },
        {
            "id": "11e7-80bf-0a5dfcbc-8e11-e7a531ef9423",
            "name": "seven",
            "type": 1,
            "mobile": "",
            "mobile2": "",
            "email": "",
            "avatar": "",
            "dept": "测试数据",
            "deptId": null,
            "loginNo": "seven",
            "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
        }
    ]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

获取以通讯录为树形结构的用户集合
--------------------------------

**请求方式：GET**  
**请求地址：**/kms/users/selectbox/contacts

**参数说明：**

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "linesPerPage": 10,
        "pageCount": 1,
        "datas": [
            {
                "id": "11e7-80be-f5cbdfaa-8e11-e7a531ef9423",
                "name": "康妮",
                "type": 1,
                "mobile": "",
                "mobile2": "",
                "email": "",
                "avatar": "",
                "dept": "测试数据",
                "deptId": "11e7-7045-2da34ac9-85f9-cbfc8973e987",
                "loginNo": "annie",
                "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
            },
            {
                "id": "11e7-7045-31a4aecf-85f9-cbfc8973e987",
                "name": "Oliver",
                "type": 1,
                "mobile": "",
                "mobile2": "",
                "email": "",
                "avatar": "",
                "dept": "测试数据",
                "deptId": "11e7-7045-2da34ac9-85f9-cbfc8973e987",
                "loginNo": "oliver",
                "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
            },
            {
                "id": "11e7-80bf-450a6f38-8e11-e7a531ef9423",
                "name": "企业文档管理员",
                "type": 1,
                "mobile": "",
                "mobile2": "",
                "email": "",
                "avatar": "",
                "dept": "江苏省邮电规划设计院",
                "deptId": "11e7-7045-1c91a1dc-85f9-cbfc8973e987",
                "loginNo": "superadmin",
                "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
            },
            {
                "id": "11e7-80bf-0a5dfcbc-8e11-e7a531ef9423",
                "name": "seven",
                "type": 1,
                "mobile": "",
                "mobile2": "",
                "email": "",
                "avatar": "",
                "dept": "测试数据",
                "deptId": "11e7-7045-2da34ac9-85f9-cbfc8973e987",
                "loginNo": "seven",
                "domainId": "11e7-7045-1c856cdb-85f9-cbfc8973e987"
            }
        ],
        "pageNo": 1,
        "rowCount": 4
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

用户分页的列表
--------------

用户分页的列表

**请求方式：GET**  
**请求地址：**/kms/users/?departmentId=:&NameOrAccount=:&roleId=: linesPerPage=:
& pageNo=:

**参数说明：**

| **参数**       | **必须** | **说明**                                                                                       |
|----------------|----------|------------------------------------------------------------------------------------------------|
| :departmentId  | 是       | 有部门id，则显示该部门下的用户，没或空则全部用户                                               |
| :nameOrAccount | 是       | 有名称时查询用户集合                                                                           |
| roleId         | 否       | 传入角色id Id 角色名称 0001 员工 0010 部门知识管理员 0020 专委会知识管理员 0100 企业知识管理员 |
| :linesPerPage  | 是       | 每页显示的条数                                                                                 |
| :pageNo        | 是       | 第几页                                                                                         |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [
            {
                "id": "b27f525b-f44f-4519-8bf1-2087382d4f56",
                "name": "邢专员（行政专员）",
                "nameLetter": null,
                "loginno": null,
                "email": null,
                "telephone": null,
                "avatar": null,
                "favoriteContacts": null,
                "superior": null,
                "roles": [
                ],
                "domainid": null,
                "defaultDepartment": "11e7-7045-1c91a1dc-85f9-cbfc8973e987",
                "calendarType": "11e7-7045-1c9a7b7d-85f9-cbfc8973e987",
                "status": 1,
                "level": 0
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

用户绑定角色
------------

为用户赋值角色(请求包体）

**请求方式：POST**  
**请求地址：**/kms/users/userroleset

**请求包体：**

```json
{
    "userIds": [
        "userId1",
        "userId2"
    ],
    "roleIds": [
        "roleId1",
        "roleId2"
    ]
}

```



**参数说明：**

请求包体，userIds的集合，RoleIds的集合。

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

角色为专委会管理员的用户分页的列表
----------------------------------

用户分页的列表

**请求方式：GET**  
**请求地址：**/kms/users/roles/realmAdmin?&name=:&linesPerPage=:&pageNo=:

**参数说明：**

| **参数**        | **必须** | **说明**                                   |
|-----------------|----------|--------------------------------------------|
| name=:          | 否       | 当为空时，把全部的专委会管理员的用户列出来 |
| :linesPerPage=: | 是       | 每页显示的条数                             |
| pageNo=:        | 是       | 第几页                                     |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "name": "oliver2",
                "nameLetter": "oliver2",
                "loginno": "oliver2",
                "email": "we@qq.com",
                "telephone": "",
                "avatar": "",
                "favoriteContacts": "",
                "superior": null,
                "roles": [
                    {
                        "id": "0010",
                        "name": "部门知识管理员",
                        "levels": 10
                    },
                    {
                        "id": "0020",
                        "name": "专委会知识管理员",
                        "levels": 20
                    }
                ],
                "domainid": "11e7-9b79-61d7f3d6-8848-c9fe21dcc7c4",
                "defaultDepartment": "11e7-a1fb-3e7ecd59-8d43-3528ba91253b",
                "calendarType": "11e7-9b79-61e22d08-8848-c9fe21dcc7c4",
                "status": 1,
                "level": 0
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

11.8 用户选择框：异步获取部门
-----------------------------

**请求方式：GET**  
**请求地址：**/kms/users/selectbox/departments?parentDeptId

=:department

**参数说明：**

| **参数**      | **必须** | **说明**                             |
|---------------|----------|--------------------------------------|
| :parentDeptId | 否       | 指定部门,若该字段为空，则获取根部门s |
| :linesPerPage | 是       | 每页显示的条数                       |
| :pageNo       | 是       | 第几页                               |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":[
        {
            "id":"11e7-a197-b8c71d7f-a900-73852bc58bcf",
            "name":"江苏省南京规划设计院",
            "type":2,
            "code":"00",
            "level":0,
            "children":[
            ]
        }]
}

```



11.9用户选择框：获取指定部门下的用户
------------------------------------

**请求方式：GET**  
**请求地址：**/kms/users/selectbox/departments/{departmentId}?pageNo=:pageNo&linesPerPage=:linesPerPage

**参数说明：**

| **参数**      | **必须** | **说明**       |
|---------------|----------|----------------|
| departmentId  | 否       | 指定部门       |
| :linesPerPage | 是       | 每页显示的条数 |
| :pageNo       | 是       | 第几页         |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "linesPerPage":10,
        "pageCount":1,
        "datas":[
            {
                "id":"11e7-a198-3969df1c-a900-73852bc58bcf",
                "name":"企业知识管理员",
                "type":1,
                "mobile":"",
                "mobile2":"",
                "email":"",
                "avatar":"",
                "dept":"江苏省南京规划设计院",
                "deptId":null,
                "loginNo":"superadmin",
                "domainId":"11e7-a197-b8af019e-a900-73852bc58bcf"
            }],
        "pageNo":1,
        "rowCount":1
    }
}

```



11.10 用户选择框：根据关键词查询用户
------------------------------------

**请求方式：GET**  
**请求地址：**/kms/users/selectbox/search?keyword=:keyword&pageNo=:pageNo&linesPerPage=:linesPerPage

**参数说明：**

| **参数**      | **必须** | **说明**       |
|---------------|----------|----------------|
| :keyword      | 是       | 查询关键词     |
| :linesPerPage | 是       | 每页显示的条数 |
| :pageNo       | 是       | 第几页         |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "linesPerPage":10,
        "pageCount":1,
        "datas":[
            {
                "id":"11e7-a198-3969df1c-a900-73852bc58bcf",
                "name":"企业知识管理员",
                "type":1,
                "mobile":"",
                "mobile2":"",
                "email":"",
                "avatar":"",
                "dept":"江苏省南京规划设计院",
                "deptId":null,
                "loginNo":"superadmin",
                "domainId":"11e7-a197-b8af019e-a900-73852bc58bcf"
            }],
        "pageNo":1,
        "rowCount":1
    }
}

```





# 订阅内容（Subscription）

## 订阅（请求包体）

对团队、专委会、知识地图进行订阅

**请求方式：POST**  
**请求地址：**/kms/subscriptions

**请求包体：**

```json
{
    "contentId": "资源id",
    "contentType": 1,
    "contentName": "团队1名称"
}

```



**参数说明：**

contentType为资源类型：1为团队，2为专委会，3为知识地图

contentName为资源名称：团队的名称或者专委会名称或者知识地图的名称

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "fcf44115-b4ac-46db-9e4b-aa1e1e8663c3",
        "userId": "b27f525b-f44f-4519-8bf1-2087382d4f56",
        "contentId": "e4fb76a6-6bf7-4ad4-9f46-869312ccc9d2",
        "contentType": 1,
        "contentName": "基础数据团队2",
        "createDate": 1503892004249
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

取消订阅(请求包体)
------------------

对团队、专委会、知识地图取消订阅

**请求方式：DELETE**  
**请求地址：**/kms/subscriptions

**请求包体：**

```json
["订阅id1","订阅id2"]
```



**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{"errcode":0,"errmsg":"ok","data":true}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询订阅内容
------------

对团队、专委会、知识地图进行订阅

**请求方式：GET**  
**请求地址：**/kms/subscriptions?userId=:&linesPerPage=:&pageNo=:

**参数说明：**

| **参数**       | **必须** | **说明**   |
|----------------|----------|------------|
| userId=:       | 是       | 用户id     |
| linesPerPage=: | 是       | 每页的数量 |
| pageNo=:       | 是       | 现在的页数 |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "cb137308-66a8-43dd-9792-13341bec4e4e",
                "userId": "cb137308-66a8-1233-9792-13341bec4e4e",
                "contentId": "d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
                "contentType": 2,
                "contentName": "团队1",
                "createDate": "2017-08-25"
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 订阅动态（SubscriptionNotice）

## 查看订阅动态

**请求方式：GET**  
**请求地址：**/kms/subscriptions/notices?userId=:&linesPerPage=:&pageNo=:

**参数说明：**

| **参数**       | **必须** | **说明**   |
|----------------|----------|------------|
| userId=:       | 是       | 用户id     |
| linesPerPage=: | 是       | 每页的数量 |
| pageNo=:       | 是       | 现在的页数 |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 5,
        "pageNo": 1,
        "datas": [
            {
                "id": "56b160f3-9b51-42ff-bf38-33d7e3fae13a",
                "userId": "cb137308-66a8-1233-9792-13341bec4e4e",
                "resourceId": "65849b39-9040-41c7-94ff-e657f74d65d0",
                "resourceName": "文件1",
                "resourceType": 1,
                "contentOwnerId": "46a1e6a4-a0f5-46a1-8d7d-559f27d2ab3f",
                "contentName": "团队名称1",
                "createDate": "2017-08-28",
                "read": false
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

删除订阅动态(请求包体)
----------------------

**请求方式：DELETE**  
**请求地址：**/kms/subscriptions/notices

**请求包体：**

```json
["订阅动态id1","订阅动态id2"]
```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{"errcode":0,"errmsg":"ok","data":true}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 申请权限（PermissionApplicationForm）

## 根据文件id获取审批人

**请求方式：GET**  
**请求地址：**/kms/applications/approvers?resourceId=:

**参数说明：**

resourceId 文件id/文件夹的id

| **参数**   | **说明**          |
|------------|-------------------|
| resourceId | 文件id/文件夹的id |

**权限说明：**

无

**返回结果：**

```json
{"errcode":0,"errmsg":"ok","data":"uuii,oliver2"}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

提交申请单（请求包体）
----------------------

**请求方式：POST**  
**请求地址：**/kms/applications

**请求包体：**

```json
{
    "resourceId": "文件id",
    "download": true,
    "preview": false,
    "reason": "我要申请"
}

```



**参数说明：**

resourceId 文件id/文件夹的id

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "5aadf7f7-c1cb-43f2-a8d4-3331849098f1",
        "userId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
        "userName": "CommonUser",
        "resourceId": "9269612b-0f41-45b6-8679-3b69dacd27e5",
        "resourceName": "审批人测试.txt",
        "resourceType": 1,
        "fileObjectType": 0,
        "resourceOwnerId": "508b54f5-555e-447f-b4d5-29a8a0cbc6fe",
        "download": true,
        "preview": false,
        "approvers": "uuii,oliver2",
        "approverIds": "[11e7-9b79-885eede2-8848-c9fe21dcc7c4,11e7-a1fd-13d2f69b-8d43-3528ba91253b]",
        "reason": "我要申请",
        "rejectReason": null,
        "createDate": 1509333087326,
        "status": 0
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

提交申请加入团队（请求包体）
----------------------------

**请求方式：POST**  
**请求地址：**/kms/applications

**请求包体：**

```json
{
    "resourceId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
    "approvers": "admin",
    "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
    "reason": "我要申请加入团队",
    "resourceType": 3
}

```



**参数说明：**

resourceId 为teamId(团队id)，resourceType为3代表申请团队申请

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "9b18d4a6-86b0-4c28-9a1c-0e40f57cd1b0",
        "userId": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
        "userName": "admin1",
        "resourceId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
        "resourceName": "团队2",
        "resourceType": 3,
        "fileObjectType": 1,
        "resourceOwnerId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
        "download": false,
        "preview": false,
        "approvers": "admin1",
        "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
        "reason": "我要申请加入团队",
        "rejectReason": null,
        "createDate": 1562727350204,
        "status": 0,
        "permission": null
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的申请
------------

**请求方式：GET**  
**请求地址：**/kms/users/:userId/applications?linesPerPage=:&pageNo=:

**参数说明：**

| **参数** | **说明**   |
|----------|------------|
| :userId  | 当前用户id |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "61eef68b-3122-40ee-b529-03f6553d8986",
                "userId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "userName": "CommonUser",
                "resourceId": "9269612b-0f41-45b6-8679-3b69dacd27e5",
                "resourceName": "审批人测试.txt",
                "resourceType": 1,
                "fileObjectType": 0,
                "resourceOwnerId": "508b54f5-555e-447f-b4d5-29a8a0cbc6fe",
                "download": true,
                "preview": true,
                "approvers": "oliver2",
                "approverIds": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "reason": "审批人设置",
                "rejectReason": null,
                "createDate": "2017-10-29",
                "status": 1
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的待办
------------

**请求方式：GET**  
**请求地址：**/kms/users/:userId/pending/applications?linesPerPage=:&pageNo=:

**参数说明：**

| **参数** | **说明**   |
|----------|------------|
| :userId  | 当前用户id |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "afd3cbf7-1f43-4716-9eff-faffa1f1e7dc",
                "userId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "userName": "CommonUser",
                "resourceId": "146f7859-860d-4243-a2de-20da74b87746",
                "resourceName": "成龙个",
                "resourceType": 0,
                "fileObjectType": 1,
                "resourceOwnerId": "11e7-a1fb-3e7ecd59-8d43-3528ba91253b",
                "download": true,
                "preview": false,
                "approvers": "oliver2",
                "approverIds": "[11e7-a1fd-13d2f69b-8d43-3528ba91253b]",
                "reason": "ffffff",
                "rejectReason": null,
                "createDate": "2017-10-29",
                "status": 0
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的已办
------------

**请求方式：GET**  
**请求地址：**/kms/users/:userId/disposing/applications?linesPerPage=:&pageNo=:

**参数说明：**

| **参数** | **说明**   |
|----------|------------|
| :userId  | 当前用户id |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "c326419c-282e-4d84-9d8f-65c858924818",
                "userId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "userName": "CommonUser",
                "resourceId": "3b6604ef-2b8e-486f-b869-a809e1c882aa",
                "resourceName": "测试",
                "resourceType": 0,
                "fileObjectType": 1,
                "resourceOwnerId": "11e7-a1fb-3e7ecd59-8d43-3528ba91253b",
                "download": true,
                "preview": false,
                "approvers": "oliver2",
                "approverIds": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "reason": "testDownloadFolder",
                "rejectReason": null,
                "createDate": "2017-10-29",
                "status": 1
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的审批后确认(团队/部门/kass)
----------------------------------

**请求方式：GET**  
**请求地址：**/kms/users/{userId}/confirmation/applications?linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**

| **参数**     | **说明**   |
|--------------|------------|
| userId       | 当前用户id |
| linesPerPage | 每页条数   |
| pageNo       | 页数       |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 3,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "2bdd733a-4e73-4e25-b320-9edb712ccd43",
                "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
                "userName": "user2",
                "resourceId": "9d89f355-145f-40e4-aebb-eb4e4ddf76bc",
                "resourceName": "ghi",
                "resourceType": 0,
                "fileObjectType": 1,
                "resourceOwnerId": "11e9-97b7-4caa76d1-bb3a-9339eb852df7",
                "download": true,
                "preview": false,
                "approvers": "admin1",
                "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "reason": "i want to download",
                "rejectReason": null,
                "createDate": "2019-07-11",
                "status": 1,
                "permission": null,
                "isRead": "unread"
            },
            {
                "id": "aad8f0d1-d803-4e92-8600-d22a7aba7747",
                "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
                "userName": "user2",
                "resourceId": "3d41e8ef-c7cc-4fcf-b8d2-2efd00391c9e",
                "resourceName": "jkl",
                "resourceType": 0,
                "fileObjectType": 1,
                "resourceOwnerId": "11e9-97b7-4caa76d1-bb3a-9339eb852df7",
                "download": true,
                "preview": false,
                "approvers": "admin1",
                "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "reason": "i",
                "rejectReason": "ddd",
                "createDate": "2019-07-11",
                "status": 2,
                "permission": null,
                "isRead": "unread"
            },
            {
                "id": "cadbba79-5067-452e-8a89-d61ad5d20937",
                "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
                "userName": "user2",
                "resourceId": "de132478-a876-41df-b2aa-7a0c264e8791",
                "resourceName": "ABCDEF",
                "resourceType": 0,
                "fileObjectType": 1,
                "resourceOwnerId": "11e9-97b7-4caa76d1-bb3a-9339eb852df7",
                "download": true,
                "preview": false,
                "approvers": "admin1",
                "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "reason": "download",
                "rejectReason": null,
                "createDate": "2019-07-10",
                "status": 1,
                "permission": null,
                "isRead": "unread"
            }],
        "from": null,
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

更新申请单为已读
----------------

**请求方式：PUT**  
**请求地址：**/kms/applications/{applicationId}/reading

**参数说明：**

| **参数**      | **说明** |
|---------------|----------|
| applicationId | 申请单id |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "d4fc4e7a-b5a3-46b8-b255-f60ae639592b",
        "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
        "userName": "user2",
        "resourceId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
        "resourceName": "团队2",
        "resourceType": 3,
        "fileObjectType": 1,
        "resourceOwnerId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
        "download": false,
        "preview": false,
        "approvers": "user3",
        "approverIds": "11e9-a221-c98ca9ad-a6b6-d110b71dd060",
        "reason": "我要申请加入团队",
        "rejectReason": "我拒绝",
        "createDate": "2019-07-11",
        "status": 2,
        "permission": null,
        "isRead": "read"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

批量更新申请单为已读
--------------------

**请求方式：PUT**  
**请求地址：**/kms/applications/reading

**请求包体：**

```json
["d8d82fa3-aa93-4bc0-a6db-a5c1406baeac","fcc2d2d8-a2ef-4e4d-bd8f-219eec030be9"]
```



**参数说明：**

| **参数**      | **说明** |
|---------------|----------|
| applicationId | 申请单id |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "d8d82fa3-aa93-4bc0-a6db-a5c1406baeac",
            "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
            "userName": "user2",
            "resourceId": "caf5a8fc-3dac-477d-a400-986cf584842c",
            "resourceName": "新1",
            "resourceType": 2,
            "fileObjectType": 1,
            "resourceOwnerId": "60446461-bfd8-4193-8b07-a3269a26aaca",
            "download": false,
            "preview": false,
            "approvers": "admin1",
            "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
            "reason": "XXXX",
            "rejectReason": null,
            "createDate": "2019-07-12",
            "status": 0,
            "permission": "upload",
            "isRead": "read"
        },
        {
            "id": "fcc2d2d8-a2ef-4e4d-bd8f-219eec030be9",
            "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
            "userName": "user2",
            "resourceId": "caf5a8fc-3dac-477d-a400-986cf584842c",
            "resourceName": "新1",
            "resourceType": 2,
            "fileObjectType": 1,
            "resourceOwnerId": "60446461-bfd8-4193-8b07-a3269a26aaca",
            "download": false,
            "preview": false,
            "approvers": "admin1",
            "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
            "reason": "XXCC",
            "rejectReason": null,
            "createDate": "2019-07-12",
            "status": 0,
            "permission": "manage",
            "isRead": "read"
        }]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的待办(团队申请)
----------------------

**请求方式：GET**  
**请求地址：**/kms/users/{userId}/team/pending/applications?linesPerPage=:&pageNo=:

**参数说明：**

| **参数** | **说明**   |
|----------|------------|
| userId   | 当前用户id |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "d4fc4e7a-b5a3-46b8-b255-f60ae639592b",
                "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
                "userName": "user2",
                "resourceId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "resourceName": "团队2",
                "resourceType": 3,
                "fileObjectType": 1,
                "resourceOwnerId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "download": false,
                "preview": false,
                "approvers": "admin1",
                "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "reason": "我要申请加入团队",
                "rejectReason": null,
                "createDate": "2019-07-11",
                "status": 0,
                "permission": null,
                "isRead": null
            }],
        "from": null,
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的已办(团队申请)
----------------------

**请求方式：GET**  
**请求地址：**/kms/users/{userId}/team/disposing/applications?linesPerPage=:&pageNo=:

**参数说明：**

| **参数** | **说明**   |
|----------|------------|
| userId   | 当前用户id |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "d4fc4e7a-b5a3-46b8-b255-f60ae639592b",
                "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
                "userName": "user2",
                "resourceId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "resourceName": "团队2",
                "resourceType": 3,
                "fileObjectType": 1,
                "resourceOwnerId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "download": false,
                "preview": false,
                "approvers": "admin1",
                "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
                "reason": "我要申请加入团队",
                "rejectReason": null,
                "createDate": "2019-07-11",
                "status": 0,
                "permission": null,
                "isRead": null
            }],
        "from": null,
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询我的审批后确认(团队申请)
----------------------------

**请求方式：GET**  
**请求地址：**/kms/users/{userId}/team/confirmation/applications?linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**

| **参数**     | **说明**   |
|--------------|------------|
| userId       | 当前用户id |
| linesPerPage | 每页条数   |
| pageNo       | 页数       |

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 3,
        "pageNo": 1,
        "datas": [
            {
                "id": "d4fc4e7a-b5a3-46b8-b255-f60ae639592b",
                "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
                "userName": "user2",
                "resourceId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "resourceName": "团队2",
                "resourceType": 3,
                "fileObjectType": 1,
                "resourceOwnerId": "dfdf77eb-2a18-4250-99aa-12686be663a7",
                "download": false,
                "preview": false,
                "approvers": "user3",
                "approverIds": "11e9-a221-c98ca9ad-a6b6-d110b71dd060",
                "reason": "我要申请加入团队",
                "rejectReason": "我拒绝",
                "createDate": "2019-07-11",
                "status": 2,
                "permission": null,
                "isRead": "unread"
            }],
        "from": null,
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

处理申请单（请求包体）
----------------------

**请求方式：PUT**  
**请求地址：**/kms/applications/:applicationId

| **参数**       | **说明** |
|----------------|----------|
| :applicationId | 申请单Id |

**请求包体：**

同意时：

```json
{
    "id": "申请单id",
    "status": 1
}

```



不同意时：

```json
{
    "id": "申请单id",
    "rejectReason": "拒绝理由",
    "status": 2
}

```



编辑时(当为kass申请单时，resource_type=2,可进行编辑，添加窗口)：  


![](media/2b69f02b2505f3450e2a66c506d24d07.png)

```json
{
    "id": "55a5ff0b-abb2-4828-8927-0b670a2145c9",
    "description": "abcdefg",
    "permission": "uploadAndRead",
    "status": 1,
    "startDate": 1569243727000,
    "endDate": 1569675727000
}

```



**参数说明：**

Status传过来的json是数字，1为通过，2为不通过

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "61eef68b-3122-40ee-b529-03f6553d8986",
        "userId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
        "userName": "CommonUser",
        "resourceId": "9269612b-0f41-45b6-8679-3b69dacd27e5",
        "resourceName": "审批人测试.txt",
        "resourceType": 1,
        "fileObjectType": 0,
        "resourceOwnerId": "508b54f5-555e-447f-b4d5-29a8a0cbc6fe",
        "download": true,
        "preview": true,
        "approvers": "oliver2",
        "approverIds": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
        "reason": "审批人设置",
        "rejectReason": null,
        "createDate": "2017-10-29",
        "status": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

批量处理申请单（请求包体）
--------------------------

**请求方式：PUT**  
**请求地址：**/kms/applications

**请求包体：**

同意时：

```json
{
    "ids": [
        "3f07bc70-c698-4eb0-a38b-b8b7be8d49f4",
        "b0e46a8c-cc48-4d74-9444-c491608516d3"],
    "status": 1
}

```



不同意时：

```json
{
    "ids":
    [
        "3f07bc70-c698-4eb0-a38b-b8b7be8d49f4",
        "b0e46a8c-cc48-4d74-9444-c491608516d3"],
    "rejectReason": "拒绝理由",
    "status": 2
}

```



**参数说明：**

Status传过来的json是数字，1为通过，2为不通过

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "3f07bc70-c698-4eb0-a38b-b8b7be8d49f4",
            "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
            "userName": "user2",
            "resourceId": "9f2b192a-91ce-4c0a-9d99-683ec94e5db7",
            "resourceName": "abc",
            "resourceType": 2,
            "fileObjectType": 1,
            "resourceOwnerId": "60446461-bfd8-4193-8b07-a3269a26aaca",
            "download": false,
            "preview": false,
            "approvers": "admin1",
            "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
            "reason": "dd",
            "rejectReason": null,
            "createDate": "2019-07-09",
            "status": 1,
            "permission": "read"
        },
        {
            "id": "b0e46a8c-cc48-4d74-9444-c491608516d3",
            "userId": "11e9-9f01-3257a890-b28b-1f246e24670c",
            "userName": "user2",
            "resourceId": "de132478-a876-41df-b2aa-7a0c264e8791",
            "resourceName": "ABCDEF",
            "resourceType": 0,
            "fileObjectType": 1,
            "resourceOwnerId": "11e9-97b7-4caa76d1-bb3a-9339eb852df7",
            "download": true,
            "preview": false,
            "approvers": "admin1",
            "approverIds": "11e9-97b7-64c3bedb-bb3a-9339eb852df7",
            "reason": "FFFFFFFFFFFF",
            "rejectReason": null,
            "createDate": "2019-07-09",
            "status": 1,
            "permission": null
        }]
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 专委会（KnowledgeRealm）

## 创建专委会(请求包体)

创建专委会（请求包体）

**请求方式：POST**  
**请求地址：**/kms/realms

**请求包体：**

```json
{
    "name": "专委会1",
    "orderNo": 98
}
```



**参数说明：**

无

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "97bda559-81b7-4e20-8b16-00a5bb0568eb",
        "name": "专委会1",
        "orderNo": 98,
        "domainId": "11e7-a197-b8af019e-a900-73852bc58bcf"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

编辑专委会(请求包体)
--------------------

编辑专委会（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/realms

**请求包体：**

```json
{
    "id": "fbded617-88e8-4ded-9f5f-fb6c958f35c9",
    "name": "专委会1",
    "orderNo": 98
}
```



**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "97bda559-81b7-4e20-8b16-00a5bb0568eb",
        "name": "专委会11",
        "orderNo": 44,
        "domainId": "11e7-a197-b8af019e-a900-73852bc58bcf"
    }
}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

删除多个专委会（单个/多个）
---------------------------

删除多个专委会

**请求方式：DELETE**  
**请求地址：** /kms/realms

**请求包体：**

```json
["专委会id","专委会id2",…]
```



**参数说明：**

**权限说明：**

**返回结果：**

有权限

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":true
}
```

无权限

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询专委会分页的列表
--------------------

专委会分页列表

**请求方式：GET**  
**请求地址：**/kms/realms/?linesPerPage=:&pageNo=:

**参数说明：**

| **参数**      | **必须** | **说明**       |
|---------------|----------|----------------|
| :linesPerPage | 是       | 每页显示的条数 |
| :pageNo       | 是       | 第几页         |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 5,
        "pageNo": 1,
        "datas": [
            {
                "id": "97bda559-81b7-4e20-8b16-00a5bb0568eb",
                "name": "专委会1",
                "orderNo": 98,
                "domainId": "11e7-a197-b8af019e-a900-73852bc58bcf"
            }
        ],
        "pageCount": 1
    }
}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

查询专委会的集合
----------------

查询专委会的集合(没分页)

**请求方式：GET**  
**请求地址：**/kms/realms/list

**参数说明：**

无。

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "97bda559-81b7-4e20-8b16-00a5bb0568eb",
            "name": "专委会1",
            "orderNo": 98,
            "domainId": "11e7-a197-b8af019e-a900-73852bc58bcf"
        }
    ]
}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

判断该专委会是否订阅
--------------------

**请求方式：GET**  
**请求地址：**/kms/realms/{realmId}/isSubscription

**参数说明：**

| **参数**    | **说明** |
|-------------|----------|
| { realmId } | 专委会id |

**权限说明：**

无

**返回结果：**

```json
{"errcode":0,"errmsg":"ok","data":{"isSubscription":true}}
```



**True为订阅，false没有订阅**

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 知识地图()

## 获取知识地图编号

**请求方式：GET**  
**请求地址：**/kms/maps/serialNumber

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{"errcode":0,"errmsg":"ok","data":"20170823002"}
```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

根据专委会id获取知识地图的包体
------------------------------

**请求方式：GET**  
**请求地址：**/kms/realms/{realmId}/maps?pageNo=:&linesPerPage=:

**参数说明：**

| **参数**     | **说明**         |
|--------------|------------------|
| { realmId }  | 知识地图id       |
| pageNo       | 现在的页数       |
| linesPerPage | 每页的显示的条数 |

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 4,
        "linesPerPage": 2,
        "pageNo": 1,
        "datas": [
            {
                "id": "125928fb-b88d-4094-894e-7b29d230d8dh",
                "title": "标题1",
                "serialNumber": "33",
                "content": "内容1",
                "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "creator": "uuii",
                "createDate": "2017-09-29",
                "lastModifyDate": "2017-09-29",
                "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e0",
                "status": "review",
                "flowHistorys": [
                    {
                        "id": "8de2f966-6629-4494-af96-ad9ab9191b43",
                        "knowledgeMapId": "125928fb-b88d-4094-894e-7b29d230d8de",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1506671457288
                    },
                    {
                        "id": "ed87f24f-1758-4606-91cd-9740ad3783e0",
                        "knowledgeMapId": "125928fb-b88d-4094-894e-7b29d230d8da",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1506673770183
                    },
                    {
                        "id": "d9ca013f-e6ce-4ee0-99c4-d6e9f2fa383b",
                        "knowledgeMapId": "125928fb-b88d-4094-894e-7b29d230d8dg",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "standard",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1506675468356
                    },
                    {
                        "id": "f6ff9e4c-fb2e-4aaf-94dd-2eecfca5b035",
                        "knowledgeMapId": "125928fb-b88d-4094-894e-7b29d230d8dh",
                        "auditor": "oliver2",
                        "auditorId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "status": "edit",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1506679289495
                    }
                ],
                "approvers": "oliver2",
                "approverIds": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approverHistorys": [
                    {
                        "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "approver": "oliver",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "approver": "oliver2",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "approver": "oliver2",
                        "status": "standard"
                    }
                ],
                "lastOperation": "submit"
            },
            {
                "id": "125928fb-b88d-4094-894e-7b29d230d8dg",
                "title": "标题1",
                "serialNumber": "33",
                "content": "内容1",
                "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "creator": "uuii",
                "createDate": "2017-09-29",
                "lastModifyDate": "2017-09-29",
                "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e0",
                "status": "standard",
                "flowHistorys": [
                    {
                        "id": "8de2f966-6629-4494-af96-ad9ab9191b43",
                        "knowledgeMapId": "125928fb-b88d-4094-894e-7b29d230d8de",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1506671457288
                    },
                    {
                        "id": "ed87f24f-1758-4606-91cd-9740ad3783e0",
                        "knowledgeMapId": "125928fb-b88d-4094-894e-7b29d230d8da",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1506673770183
                    }
                ],
                "approvers": "uuii",
                "approverIds": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approverHistorys": [
                    {
                        "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "approver": "oliver",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "approver": "oliver2",
                        "status": "initiate"
                    }
                ],
                "lastOperation": "submit"
            }
        ],
        "pageCount": 2
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

保存知识地图(请求包体)
----------------------

保存知识地图（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/maps

**请求包体：**

```json
{
    "id": "知识地图id",
    "content": "内容1",
    "serialNumber":"编号1",
    "title": "标题1",
    "content": "内容1",
    "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1"
}

```



**参数说明：**

**权限说明：**

**返回结果：**

是企业知识管理员

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c6",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": 1507544072155,
        "lastModifyDate": 1507544073090,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "initiate",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            }
        ],
        "approvers": null,
        "approverIds": null,
        "mode": null,
        "approverHistorys": [
        ],
        "lastOperation": "submit"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

提交(请求包体)
--------------

提交知识地图（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/maps/submitting

**请求包体：**

```json
{
    "id": "知识地图id",
    "title": "标题1",
    "serialNumber": "33",
    "knowledgeReamlId": "专委会id",
    "approverHistorys": [
        {
            "approverId": "用户id",
            "approver": "用户名"
        },
        {
            "approverId": "用户id",
            "approver": "用户名"
        }
    ],
    "content": "内容1"
}

```



**参数说明：**

创建和提交合并，第一次提交为id为空为创建

当企业知识管理员创建了知识地图后，指定专委会管理员，

专委会管理员指定1个或多个编辑人

Status状态说明：

| **参数** | **说明** |
|----------|----------|
| initiate | 新建     |
| standard | 指标     |
| edit     | 编辑     |
| review   | 审核     |
| pass     | 审定     |
| release  | 发布     |

**权限说明：**

当不是企业知识管理员：

```json
{"errcode":401,"errmsg":"不是企业知识管理员，无权创建知识地图"}
```



**返回结果：**

初始阶段没有选择专委会管理员，在按提交返回数据：此数据跟创建的数据除了(lastOperation)不一样，其他一样，lastOperation:select
realmAdmin选择专委会管理员

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c6",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": "2017-10-09",
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "initiate",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            }
        ],
        "approvers": "",
        "approverIds": "",
        "mode": null,
        "approverHistorys": [
        ],
        "lastOperation": "select realmAdmin"
    }
}

```



初始阶段创建选择的专委会管理员,选择完按提交，状态变指标

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c7",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507545004875,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "standard",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            }
        ],
        "approvers": "oliver,oliver2",
        "approverIds":
        "11e7-9b79-885eede2-8848-c9fe21dcc7c4,11e7-a1fd-13d2f69b-8d43-3528ba91253b",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            }
        ],
        "lastOperation": "submit"
    }
}

```



如果指标阶段没有传相关的编辑人，提交，返回的数据，此数据跟指标的数据除了(lastOperation)不一样，其他一样，lastOperation:select
user选择用户

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c7",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": "2017-10-09",
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "standard",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            }
        ],
        "approvers": "oliver,oliver2",
        "approverIds":
        "11e7-9b79-885eede2-8848-c9fe21dcc7c4,11e7-a1fd-13d2f69b-8d43-3528ba91253b",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            }
        ],
        "lastOperation": "select user"
    }
}

```



在指标下，专委会管理员选择相关的编辑人编辑，提交，返回结果状态为编辑：

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c8",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507545666107,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "edit",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "a4e2f4be-b1f9-410e-b8ad-c424d3cbd93f",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545666107
            }
        ],
        "approvers": "CommonUser",
        "approverIds": "11e7-a5b2-78a52539-94b8-0b402482f12a",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "submit"
    }
}

```



在编辑的阶段，编辑人编辑内容，按提交，返回的结果状态为审核：

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c9",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507621018478,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "review",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            }
        ],
        "approvers": "uuii",
        "approverIds": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "submit"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

知识地图回退
------------

企业知识管理员审查（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/maps/{mapId}/rollback

知识地图回退
------------

知识地图回退（请求包体）

**请求方式：PUT**  
**请求地址：**/kms/maps/{mapId}/rollback

**请求包体：**

```json
{
    "flowHistorys": [
        {
            "remark": "无权访问"
        }
    ]
}

```



**参数说明：**

| **参数** | **说明**   |
|----------|------------|
| {mapId}  | 知识地图id |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c12",
        "title": "标题1",
        "serialNumber": "33",
        "content": "",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507683997505,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "initiate",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            },
            {
                "id": "ca988d9e-3680-495c-9570-973f4ff3efa5",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c11",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "review",
                "actionType": 1,
                "remark": null,
                "createDate": 1507633682743
            },
            {
                "id": "bdda8e73-0e22-4d5f-8b38-09b58b42649e",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c12",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "pass",
                "actionType": 1,
                "remark": null,
                "createDate": 1507640751275
            },
            {
                "id": "05d14532-6cab-47fd-8c15-5b3781de45a2",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c12",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "release",
                "actionType": -1,
                "remark": null,
                "createDate": 1507683997505
            }
        ],
        "approvers": "",
        "approverIds": "",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "rollback"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

同意/驳回(请求包体) 
--------------------

企业知识管理员审查（请求包体）

**请求方式：UPDATE**  
**请求地址：**/kms/maps/{mapId}/approving

**请求包体(驳回，不通过)：**

```json
{
    "id": "知识地图id",
    "flowHistorys": [
        {
            "actionType": -1,
            "remark": "无权访问"
        }
    ]
}

```



**请求包体(通过)：**

```json
{
    "id": "知识地图id",
    "flowHistorys": [
        {
            "actionType": 1
        }
    ]
}

```



**参数说明：**

**参数说明：**

\-1不通过，1通过，0未处理

**权限说明：**

无。

**返回结果：**

当状态为”review”,企业知识管理员审批，当驳回时，返回的数据：

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c10",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507631836153,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "edit",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            },
            {
                "id": "7b70804c-9938-4451-9c46-eded3bcbfaff",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c10",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "review",
                "actionType": -1,
                "remark": "无权访问",
                "createDate": 1507631836153
            }
        ],
        "approvers": "CommonUser",
        "approverIds": "11e7-a5b2-78a52539-94b8-0b402482f12a",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "rollback"
    }
}

```



**当状态为**”review”时，企业知识管理员审批，通过返回的数据：

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c10",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507633429790,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "pass",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            },
            {
                "id": "d6fab0c8-25f0-4fe7-af05-fc0b3b9a15e9",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c10",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "review",
                "actionType": 1,
                "remark": null,
                "createDate": 1507633429790
            }
        ],
        "approvers": "oliver,oliver2",
        "approverIds":
        "11e7-9b79-885eede2-8848-c9fe21dcc7c4,11e7-a1fd-13d2f69b-8d43-3528ba91253b",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "submit"
    }
}

```



**当状态为**”pass”时，专委会管理员审定，不通过返回的数据：

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c10",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507633883922,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "edit",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            },
            {
                "id": "06035293-f236-477d-ad3b-2fbef17c3ba2",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c10",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "review",
                "actionType": -1,
                "remark": "无权访问",
                "createDate": 1507633883922
            }
        ],
        "approvers": "CommonUser",
        "approverIds": "11e7-a5b2-78a52539-94b8-0b402482f12a",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "rollback"
    }
}

```



**当状态为**”pass”时，专委会管理员审定，通过返回的数据：

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c11",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": 1507636255982,
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "release",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            },
            {
                "id": "f832756a-9b65-44d5-bce7-a88871c5f26f",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c11",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "review",
                "actionType": 1,
                "remark": null,
                "createDate": 1507634823415
            },
            {
                "id": "9d9b72e0-3d3d-4ea5-bdfa-9f077b30d7fc",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c11",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "pass",
                "actionType": 1,
                "remark": null,
                "createDate": 1507636255982
            }
        ],
        "approvers": "uuii",
        "approverIds": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "mode": null,
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "submit"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

根据知识地图id查找知识地图
--------------------------

**请求方式：GET**  
**请求地址：**/kms/maps/{mapId}

**参数说明：**

**权限说明：**

打开知识地图，超级管理员为阅读模式，编辑人为编辑模式，其他为(在没发布之前)，弹出提示”还没发布”

**返回结果：**

已经发布的知识地图，任何都可以看

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c12",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": "2017-10-10",
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "release",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            },
            {
                "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "auditor": "CommonUser",
                "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "status": "edit",
                "actionType": 1,
                "remark": null,
                "createDate": 1507621018478
            },
            {
                "id": "ca988d9e-3680-495c-9570-973f4ff3efa5",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c11",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "review",
                "actionType": 1,
                "remark": null,
                "createDate": 1507633682743
            },
            {
                "id": "bdda8e73-0e22-4d5f-8b38-09b58b42649e",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c12",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "pass",
                "actionType": 1,
                "remark": null,
                "createDate": 1507640751275
            }
        ],
        "approvers": "uuii",
        "approverIds": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "mode": "read",
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "submit"
    }
}

```



如果用户为企业知识管理员，且该知识地图是自己创造的，且状态为初始状态，且没指定专委会的审批人，则mode=edit

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c6",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": "2017-10-09",
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "initiate",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            }
        ],
        "approvers": "",
        "approverIds": "",
        "mode": "edit",
        "approverHistorys": [
        ],
        "lastOperation": "submit"
    }
}

```



状态为指标，且用户是专委会管理员，且是企业知识管理员指派的专委会管理员，mode=edit

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c7",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": "2017-10-09",
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "standard",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            }
        ],
        "approvers": "oliver,oliver2",
        "approverIds":
        "11e7-9b79-885eede2-8848-c9fe21dcc7c4,11e7-a1fd-13d2f69b-8d43-3528ba91253b",
        "mode": "edit",
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            }
        ],
        "lastOperation": "submit"
    }
}

```



状态为编辑，且用户是专委会管理员指定的编辑人mode=edit

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "4f501417-deb3-4fe6-a359-2e35260e08c8",
        "title": "标题1",
        "serialNumber": "33",
        "content": "内容1",
        "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
        "creator": "uuii",
        "createDate": "2017-10-09",
        "lastModifyDate": "2017-10-09",
        "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
        "status": "edit",
        "flowHistorys": [
            {
                "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507544073089
            },
            {
                "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "initiate",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545004875
            },
            {
                "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                "auditor": "uuii",
                "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "status": "standard",
                "actionType": 1,
                "remark": null,
                "createDate": 1507545718264
            }
        ],
        "approvers": "CommonUser",
        "approverIds": "11e7-a5b2-78a52539-94b8-0b402482f12a",
        "mode": "edit",
        "approverHistorys": [
            {
                "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "approver": "oliver",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                "approver": "oliver2",
                "status": "initiate"
            },
            {
                "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                "approver": "CommonUser",
                "status": "standard"
            }
        ],
        "lastOperation": "submit"
    }
}

```



不是企业知识管理员指定的专委会管理员，不是专委会管理员指定编辑人mode=edit

**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

我的待办
--------

**请求方式：GET**  
**请求地址：**/kms/maps/{userId}/pending?pageNo=:&linesPerPage=:

**参数说明：**

| **参数**     | **说明**         |
|--------------|------------------|
| { userId}    | 用户id           |
| pageNo       | 现在的页数       |
| linesPerPage | 每页的显示的条数 |

**参数说明：**

超级管理员审核，专委会管理员审定，有两个角色的有审核和审定

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 5,
        "pageNo": 1,
        "datas": [
            {
                "id": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                "title": "标题1",
                "serialNumber": "33",
                "content": "内容1",
                "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "creator": "uuii",
                "createDate": "2017-10-09",
                "lastModifyDate": "2017-10-10",
                "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
                "status": "review",
                "flowHistorys": [
                    {
                        "id": "a9243b6b-31ba-47b4-81ea-e90cdc242576",
                        "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c6",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1507544073089
                    },
                    {
                        "id": "b8844af3-72e8-493e-89ee-9dcef51aa153",
                        "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c7",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1507545004875
                    },
                    {
                        "id": "56907b1f-86f3-43d1-9efa-b9bd41a668c0",
                        "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c8",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "standard",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1507545718264
                    },
                    {
                        "id": "a2e024ae-25ab-4b73-bdd7-81612a82deca",
                        "knowledgeMapId": "4f501417-deb3-4fe6-a359-2e35260e08c9",
                        "auditor": "CommonUser",
                        "auditorId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                        "status": "edit",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1507621018478
                    }
                ],
                "approvers": "uuii",
                "approverIds": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "mode": null,
                "approverHistorys": [
                    {
                        "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "approver": "oliver",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "approver": "oliver2",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-a5b2-78a52539-94b8-0b402482f12a",
                        "approver": "CommonUser",
                        "status": "standard"
                    }
                ],
                "lastOperation": "submit"
            }
        ],
        "pageCount": 1
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

我的已办
--------

**请求方式：GET**  
**请求地址：**/kms/maps/{userId}/disposing?pageNo=:&linesPerPage=:

**参数说明：**

| **参数**     | **说明**         |
|--------------|------------------|
| { userId}    | 用户id           |
| pageNo       | 现在的页数       |
| linesPerPage | 每页的显示的条数 |

**参数说明：**

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 2,
        "linesPerPage": 1,
        "pageNo": 1,
        "datas": [
            {
                "id": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                "title": "11知识",
                "serialNumber": "20171017003",
                "content": "<p>知识地图1909809809090kklklklkloopopop</p>",
                "creatorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "creator": "uuii",
                "createDate": "2017-10-17",
                "lastModifyDate": "2017-10-17",
                "knowledgeReamlId": "a7a1f3d1-09a8-4ea6-884d-fc35f567e6e1",
                "status": "release",
                "flowHistorys": [
                    {
                        "id": "e287d6c8-3562-4b7f-bf64-6c6c50d2b8d1",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508205704897
                    },
                    {
                        "id": "5a260b10-5d2d-427b-be05-3a40d947b2b9",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "oliver2",
                        "auditorId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "status": "standard",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508205770627
                    },
                    {
                        "id": "7dc00a3f-7d31-4b2c-b577-212b0366f09e",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "edit",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508205825470
                    },
                    {
                        "id": "c252d4dd-7233-46e4-8ebe-b3e367b69002",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "review",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508205838200
                    },
                    {
                        "id": "3eee855c-b472-48c1-9519-53e66cd397d8",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "oliver2",
                        "auditorId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "status": "pass",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508205864402
                    },
                    {
                        "id": "b9fd0d2d-04ad-4c91-aba5-b63e289a6fe0",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "release",
                        "actionType": 0,
                        "remark": null,
                        "createDate": 1508205971477
                    },
                    {
                        "id": "e6a63215-264c-4c5e-ac40-5abffe9f96fb",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "initiate",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508206024807
                    },
                    {
                        "id": "246d4686-66cf-404b-9656-183f61357f35",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "standard",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508206127363
                    },
                    {
                        "id": "b9b7b072-fedc-496d-89cc-f8295dd5ee2b",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "edit",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508228553721
                    },
                    {
                        "id": "71efc4a9-c737-45ec-a4d1-5eeccb1c3daa",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "review",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508228556744
                    },
                    {
                        "id": "b661c14d-ebf1-4066-b79a-817970618ebf",
                        "knowledgeMapId": "9e0c7332-e91f-4bbb-95a6-8bc7e18c47d9",
                        "auditor": "uuii",
                        "auditorId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "status": "pass",
                        "actionType": 1,
                        "remark": null,
                        "createDate": 1508228561103
                    }
                ],
                "approvers": "uuii",
                "approverIds": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                "mode": null,
                "approverHistorys": [
                    {
                        "approverId": "11e7-a1fd-13d2f69b-8d43-3528ba91253b",
                        "approver": "oliver2",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "approver": "uuii",
                        "status": "initiate"
                    },
                    {
                        "approverId": "11e7-9b79-885eede2-8848-c9fe21dcc7c4",
                        "approver": "uuii",
                        "status": "standard"
                    }
                ],
                "lastOperation": "submit"
            }
        ],
        "pageCount": 2
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
|----------|-----------------------------------|
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 水印配置

## 获取水印配置信息

**请求方式：GET**  
**请求地址：**/kms/watermark/config

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "status":false,
        "preview":false,
        "download":true,
        "print":true,
        "mode":"custom",
        "customContent":"的风格"
    }
}

```

## 更新水印配置文件信息

**请求方式：PUT**  
**请求地址：**/kms/watermark/config

**请求包体**

```json
{
    "status":false,
    "preview":false,
    "download":true,
    "print":true,
    "mode":"custom",
    "customContent":"的风格"
}

```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "status":false,
        "preview":false,
        "download":true,
        "print":true,
        "mode":"custom",
        "customContent":"的风格"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
| -------- | --------------------------------- |
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 标签



## 获取标签树

**请求方式：**GET  
**请求地址：**/kms/categorys/tree

**参数说明：**

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":[
        {
            "name":"顶层",
            "id":"fd7be7e0-3a5b-46cb-b275-29ca71efbc2c",
            "Children":[
            ],
            "parentId":""
        },
        {
            "name":"大管",
            "id":"fdf83788-b087-4397-b114-cac8de74353f",
            "Children":[
            ],
            "parentId":""
        }]
}



```



**参数说明：**

| **参数** | **说明**                                |
| -------- | --------------------------------------- |
| errcode  | 返回码                                  |
| errmsg   | 对返回码的文本描述内容                  |
| data     | 返回的对象数据，数据结构参考[Logs对象]( |



## 创建标签

**请求方式：POST**  
**请求地址：**/kms/files/categorys/paste

**请求包体**

```json
{
    "name":["sd"],
    "parentId":""
}
```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":[
        {
            "id":"c9a78981-63d9-427c-8520-f2a1cde9f173",
            "name":"sd",
            "parentId":null,
            "domainId":"3CffNlgt9B9StIjIUPB"
        }]
}
```



**参数说明：**

| **参数** | **说明**                          |
| -------- | --------------------------------- |
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

## 更新标签

**请求方式：PUT**  
**请求地址：**/kms/categorys

**请求包体**

```json
{
    "id":"01137638-d5e2-4a2a-9a79-91cc676e4422",
    "name":"精细dfdf",
    "parentId":"",
    "parentName":""
}

```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":{
        "id":"01137638-d5e2-4a2a-9a79-91cc676e4422",
        "name":"精细dfdf",
        "parentId":"",
        "domainId":"3CffNlgt9B9StIjIUPB"
    }
}

```



**参数说明：**

| **参数** | **说明**                          |
| -------- | --------------------------------- |
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

## 批量对文件贴标签

**请求方式：PUT**  
**请求地址：**/kms/files/categorys/paste

**请求包体**

```json
[{
	"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
	"categorys": [{
		"categoryId": "123456",
		"categoryName": "知识文档",
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"isAuto": true
	}, {
		"categoryId": "123456",
		"categoryName": "广州市",
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"isAuto": true
	}]
}, {
	"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
	"categorys": [{
		"categoryId": "123456",
		"categoryName": "知识文档",
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"isAuto": true
	}, {
		"categoryId": "123456",
		"categoryName": "广州市",
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"isAuto": true
	}]
}]


```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"categorys": [{
			"categoryId": "123456",
			"categoryName": "知识文档",
			"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
			"isAuto": true
		}, {
			"categoryId": "123456",
			"categoryName": "广州市",
			"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
			"isAuto": true
		}]
	}, {
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"categorys": [{
			"categoryId": "123456",
			"categoryName": "知识文档",
			"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
			"isAuto": true
		}, {
			"categoryId": "123456",
			"categoryName": "广州市",
			"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
			"isAuto": true
		}]
	}]
}


```



**参数说明：**

| **参数** | **说明**                          |
| -------- | --------------------------------- |
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

## 单个对文件贴标签

**请求方式：PUT**  
**请求地址：**/kms/file/categorys/paste

**请求包体**

```json
{
	"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
	"categorys": [{
		"categoryId": "123456",
		"categoryName": "知识文档",
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"isAuto": true
	}, {
		"categoryId": "123456",
		"categoryName": "广州市",
		"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"isAuto": true
	}]
}

```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
		"name": "2018.09.05 温国辉 在全市治理违法建设工作会议上的讲话.docx",
		"creatorId": "zPsp2hk7CEwtqeMCwtj",
		"creator": "管理员",
		"createDate": "2020-05-29",
		"lastModifyDate": "2020-05-29T08:32:12.000+0000",
		"diskId": "0dd1e1c1-b5dd-41f4-8e3e-c0479448faf9",
		"folderId": "a56f8f78-52b4-44ef-af2e-fe4136974500",
		"folder": false,
		"size": 31383,
		"path": "0dd1e1c1-b5dd-41f4-8e3e-c0479448faf9/a56f8f78-52b4-44ef-af2e-fe4136974500",
		"type": "docx",
		"url": "0dd1e1c1-b5dd-41f4-8e3e-c0479448faf9/202005/59c07a5a-d323-4fb0-a0f5-4aaa1e774056.docx",
		"originType": 1,
		"originId": null,
		"categorys": "知识文档,广州市",
		"categorysJson": [{
			"categoryId": "123456",
			"categoryName": "知识文档",
			"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
			"isAuto": true
		}, {
			"categoryId": "123456",
			"categoryName": "广州市",
			"fileId": "59c07a5a-d323-4fb0-a0f5-4aaa1e774056",
			"isAuto": true
		}],
		"views": 0,
		"lastViewDate": null,
		"downloads": 0,
		"lastDownloadDate": null,
		"shares": 0,
		"lastShareDate": null,
		"collects": 0,
		"lastCollectDate": null,
		"lastEditDate": null,
		"good": 0,
		"bad": 0
	}
}


```



**参数说明：**

| **参数** | **说明**                          |
| -------- | --------------------------------- |
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

# 
## 批量对文件夹中文件贴标签

**请求方式：PUT**  
**请求地址：**/kms/folderFiles/categorys/paste

**请求包体**

```json
[
    {
        "folderId": "c3864c0d-0434-45e5-9e87-0b84fcfc095c",
        "categorys": [
            {
                "categoryId": "09082a0e-3b48-4633-a503-7935aa371b2e",
                "categoryName": "标签测试2",
                "isAuto": false
            }
        ]
    }
]


```

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "folderId": "c3864c0d-0434-45e5-9e87-0b84fcfc095c",
            "categorys": [
                {
                    "categoryId": "09082a0e-3b48-4633-a503-7935aa371b2e",
                    "categoryName": "标签测试2",
                    "isAuto": false
                }
            ]
        }
    ]
}


```



**参数说明：**

| **参数** | **说明**                          |
| -------- | --------------------------------- |
| Errcode  | 返回码                            |
| Errmsg   | 对返回码的文本描述内容            |
| Data     | 返回的视图对象，数据结构参考\#4.2 |

## 删除文件单个标签

**请求方式：DELETE**  
**请求地址：**/kms/files/deleteFileCategory?fileId={fileId}&categoryName={categoryName}

**参数说明：**

| **参数**     | **说明** |
| ------------ | -------- |
| fileId       | 文件id   |
| categoryName | 标签名称 |

**请求包体**

**参数说明：**

无

**权限说明：**

无

**返回结果：**

```json
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "779fcb07-2e2f-483f-a5ce-eb7426bde7cb",
		"name": "选择框调用视图.xlsx",
		"creatorId": "M88FvL0rnPRvkCTzLkF",
		"creator": "sam01",
		"createDate": "2020-09-14",
		"lastModifyDate": "2020-09-14T05:50:54.000+0000",
		"diskId": "M88FvL0rnPRvkCTzLkF",
		"folderId": "c3864c0d-0434-45e5-9e87-0b84fcfc095c",
		"folder": false,
		"size": 20052,
		"path": "M88FvL0rnPRvkCTzLkF/c3864c0d-0434-45e5-9e87-0b84fcfc095c",
		"type": "xlsx",
		"url": "M88FvL0rnPRvkCTzLkF/202009/779fcb07-2e2f-483f-a5ce-eb7426bde7cb.xlsx",
		"originType": 1,
		"originId": null,
		"categorys": "1112",
		"categorysJson": [{
			"categoryName": "1112",
			"categoryId": "a995653a-04e1-412f-976e-3fecc6cca026",
			"isAuto": false
		}],
		"views": 0,
		"lastViewDate": null,
		"downloads": 0,
		"lastDownloadDate": null,
		"shares": 0,
		"lastShareDate": null,
		"collects": 0,
		"lastCollectDate": null,
		"lastEditDate": null,
		"good": 0,
		"bad": 0
	}
}
```



**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| Errcode  | 返回码                 |
| Errmsg   | 对返回码的文本描述内容 |
| Data     | 返回结果               |



# 日志

## 我的日志查询

>   根据查询条件查询我的日志

**请求方式：**GET  
**请求地址：**/kms/users/:userId/logs?keyWord=:keyword&operationType=:operationType&pageNo=:pageno&linesPerPage
=:linesperpage

**参数说明：**

| **参数**       | **必须** | **说明**   |
|----------------|----------|------------|
| :userId        | 是       | 查询用户ID |
| :keyword       | 否       | 查询关键字 |
| :operationType | 是       | 操作类型   |
| :linesperpage  | 是       | 每页条数   |
| :pageNo        | 是       | 当前页     |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "rowCount":2,
        "linesPerPage":2,
        "pageNo":1,
        "datas":[
            {
                "id":"86477af4-37ea-4447-9673-86a4f2b65a28",
                "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
                "resourceName":"技术研发部_二级目录1_1.txt",
                "resourceType":1,
                "creator":"邢专员（行政专员）",
                "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
                "deptId":"11e7-7045-1c91a1dc-85f9-cbfc8973e987",
                "deptName":"XXX",
                "createDate":"2017-08-18",
                "operationType":4
            }],
        "pageCount":1
    }
}

```



**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的对象数据，数据结构参考[Logs对象](#logs日志) |

KM访问明细
----------

>   根据查询条件查询日志

**请求方式：**GET  
**请求地址：**

/kms/logs?userId=:userId
&deptId=:deptId&startDate=:startDate&endDate:endDate&keyWord=:keyword&operationType=:operationType&pageNo=:pageno&linesPerPage
=:linesperpage

**参数说明：**

| **参数**       | **必须** | **说明**   |
|----------------|----------|------------|
| :userId        | 否       | 查询用户ID |
| :keyword       | 否       | 查询关键字 |
| :operationType | 否       | 操作类型   |
| :deptId        | 否       | 部门ID     |
| :startDate     | 否       | 开始时间   |
| :endDate       | 否       | 结束时间   |
| :linesperpage  | 是       | 每页条数   |
| :pageNo        | 是       | 当前页     |

**权限说明：**

无。

**返回结果：**

```json
{
    "errcode":0,
    "errmsg":"ok",
    "data":
    {
        "rowCount":2,
        "linesPerPage":2,
        "pageNo":1,
        "datas":[
            {
                "id":"86477af4-37ea-4447-9673-86a4f2b65a28",
                "resourceId":"d46b2ed9-ec75-40c6-9bdf-d35e7aa309dc",
                "resourceName":"技术研发部_二级目录1_1.txt",
                "resourceType":1,
                "creator":"邢专员（行政专员）",
                "creatorId":"b27f525b-f44f-4519-8bf1-2087382d4f56",
                "deptId":"11e7-7045-1c91a1dc-85f9-cbfc8973e987",
                "deptName":"XXX",
                "createDate":"2017-08-18",
                "operationType":4
            }],
        "pageCount":1
    }
}

```



**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的对象数据，数据结构参考[Logs对象](#logs日志) |

#   **个人设置（UserSetups）**

##  个人信息设置

>   服务器返回保存是否的结果。

**请求方式：** POST  
**请求地址：**/kms/usersetups/detail

**请求包体：**

```
{
        "name":"1111",
        "email":"1111",
        "telephone":"1111"
        
    }

```

**参数说明：**

| **参数**  | **必须** | **说明** |
|-----------|----------|----------|
| name      | 是       | 用户名称 |
| email     | 是       | 用户邮箱 |
| telephone | 是       | 用户电话 |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |

## 密码设置
--------

>   服务器返回保存是否成功的结果。

**请求方式：** POST  
**请求地址：**/kms/usersetups/password

**请求包体：**

```
{
        "oldPassword":"1111",
        "newpassword":"1111",
        "confirmPassword":"1111"
        
    }


```

**参数说明：**

| **参数**        | **必须** | **说明** |
|-----------------|----------|----------|
| oldPassword     | 是       | 原密码   |
| newpassword     | 是       | 新密码   |
| confirmPassword | 是       | 确认密码 |

**权限说明：**

无。

**返回结果：**

**参数说明：**

| **参数** | **说明**                                          |
|----------|---------------------------------------------------|
| errcode  | 返回码                                            |
| errmsg   | 对返回码的文本描述内容                            |
| data     | 返回的表单对象，数据结构参考[\#3.3](#获取pdf文件) |


全局错误码参考
==============

**状态码说明：**

| **状态码** | **说明** |
|------------|----------|
| \-1        | 系统繁忙 |
| 0          | 处理成功 |
| 40001      |          |
| 40002      |          |
| 40003      |          |
| 40004      |          |
| 40005      |          |

**错误信息数据结构（errors）：**

```json
{
    "errcode":40035,
    "errmsg":"Validation Failed",
    "errors":[
        {
            "errcode":40035,
            "field":"name",
            "errmsg":"name cannot have fancy characters"
        },
        {
            "errcode":40035,
            "field":"age",
            "errmsg":"age cannot be blank"
        }
    ]
}

```



**错误信息参数说明：**

| **参数** | **说明**                     |
|----------|------------------------------|
| errcode  | 返回码                       |
| errmsg   | 状态码对应的信息文本         |
| field    | 字段名称（错误对应的作用域） |

# 对象说明

## Disk网盘

| **参数** | **说明**                                                                                                                        |
|----------|---------------------------------------------------------------------------------------------------------------------------------|
| id       | 网盘id                                                                                                                          |
| name     | 网盘名称                                                                                                                        |
| type     | 网盘类型：                                                                                                                      |
|          | 类型-部门KM                                                                                                                     |
|          | TYPE_DEPARTMENT = 1;                                                                                                            |
|          | 类型-团队KM                                                                                                                     |
|          | TYPE_TEAM = 2;                                                                                                                  |
|          | 类型-专委会KM                                                                                                                   |
|          | TYPE_KNOWLEDGE_MAP = 4;                                                                                                         |
|          | 类型-个人                                                                                                                       |
|          | TYPE_PERSON = 8;                                                                                                                |
| ownerId  | 网盘持有者id eg：部门网盘的ownerId为 部门id ：                                                                                  |
| orderNo  | 排序号                                                                                                                          |

Folder 目录
-----------

| **参数**       | **说明**                                                                                                        |
|----------------|-----------------------------------------------------------------------------------------------------------------|
| id             | 目录ID                                                                                                          |
| name           | 目录名称                                                                                                        |
| creator        | 创建人名称                                                                                                      |
| creatorId      | 创建人ID ：                                                                                                     |
| diskId         | 所在网盘ID                                                                                                      |
| lastModifyDate | 修改日期                                                                                                        |
| createDate     | 创建日期                                                                                                        |
| folderId       | 所属的目录ID                                                                                                    |
| folder         | 是否为文件夹                                                                                                    |
| size           | 文件大小（可忽略）                                                                                              |
| path           | 文件路径                                                                                                        |
| orderNo        | 排序号                                                                                                          |
| type           | 目录类型: 普通目录： TYPE_NORMAL = 0 个人收藏目录： TYPE_PERSIONAL_COLLECTION = 1 网盘根目录 TYPE_DISK_ROOT = 2 |

File文件
--------

| **参数**         | **说明**                                                                             |
|------------------|--------------------------------------------------------------------------------------|
| id               | 目录ID                                                                               |
| name             | 目录名称                                                                             |
| creator          | 创建人名称                                                                           |
| creatorId        | 创建人ID ：                                                                          |
| diskId           | 所在网盘ID                                                                           |
| lastModifyDate   | 修改日期                                                                             |
| createDate       | 创建日期                                                                             |
| folderId         | 所属的目录ID                                                                         |
| folder           | 是否为文件夹                                                                         |
| size             | 文件大小（可忽略）                                                                   |
| path             | 文件路径                                                                             |
| orderNo          | 排序号                                                                               |
| url              | 实体文件路径                                                                         |
| originType       | 文件源： 来源类型：上传 ORIGIN_TYPE_UPLOAD = 1 来源类型：分享 ORIGIN_TYPE_SHARED = 2 |
| originId         | 来源类型为上传时，此字段为null 来源类型为分享时，此字段为源文件的ID                  |
| views            | 浏览次数                                                                             |
| lastViewDate     | 最近浏览时间                                                                         |
| downloads        | 下载次数                                                                             |
| lastDownloadDate | 最近下载时间                                                                         |
| shares           | 分享次数                                                                             |
| lastShareDate    | 最近分享时间                                                                         |
| collects         | 收藏次数                                                                             |
| lastCollectDate  | 最近收藏时间                                                                         |
| good             | 好评次数                                                                             |
| bad              | 差评次数                                                                             |
| type             | 文件类型                                                                             |

SearchFile查询文件
------------------

| **参数**       | **说明**           |
|----------------|--------------------|
| id             | 目录ID             |
| name           | 目录名称           |
| creator        | 创建人名称         |
| creatorId      | 创建人ID ：        |
| diskId         | 所在网盘ID         |
| lastModifyDate | 修改日期           |
| createDate     | 创建日期           |
| folderId       | 所属的目录ID       |
| folder         | 是否为文件夹       |
| size           | 文件大小（可忽略） |
| path           | 文件路径           |
| fileType       | 文件类型           |
| content        | 文件内容           |
| pageCount      | 总页数             |

Role角色
--------

| **参数**  | **说明**                                                                                                                |
|-----------|-------------------------------------------------------------------------------------------------------------------------|
| Id        | 角色ID                                                                                                                  |
| Name      | 角色名称                                                                                                                |
| Level     | 角色级别：（id） 级别（levels）                                                                                         |
|           | 普通员工：0001 0                                                                                                        |
|           | 部门知识管理员：0010 10                                                                                                 |
|           | 专委会知识管理员：0020 20                                                                                               |
|           | 企业知识管理员：0100 100                                                                                                |
| creatorId | 创建人ID ：                                                                                                             |

Member成员
----------

| **参数** | **说明**                               |
|----------|----------------------------------------|
| Id       | 成员ID                                 |
| Name     | 成员名称                               |
| Type     | 成员类型：（级别）                     |
|          | 普通成员：0                            |
|          | 管理员：1                              |
| userId   | 用户ID ：                              |

User用户
--------

| **参数**          | **说明**             |
|-------------------|----------------------|
| Id                | 用户ID               |
| Name              | 用户姓名             |
| nameLetter        | 用户姓名拼音首字母   |
| loginno           | ？ ：                |
| Email             | 用户电子邮件         |
| telephone         | 电话号码             |
| Avatar            | 用户头像（json）     |
| favoriteContacts  | 常用联系人           |
| superior          | 上级id               |
| Roles             | 所属权限组           |
| domainid          | 企业域id             |
| defaultDepartment | 默认部门             |
| calendarType      | 工作日历种类         |
| Status            | 状态，表示是否生效。 |

Team团队
--------

| **参数**       | **说明**                                                |
|----------------|---------------------------------------------------------|
| Id             | 团队ID                                                  |
| Name           | 团队名称                                                |
| serialNumber   | 团队编号                                                |
| Description    | 描述 ：                                                 |
| creatorId      | 创建者id                                                |
| Creator        | 创建者                                                  |
| Members        | 团队的成员集合                                          |
| Stages         | 团队的阶段集合                                          |
| deptPermission | 部门权限（字符串）                                      |
|                | 部门预览： preview                                      |
|                | 部门下载： download                                     |
| comPermission  | 公司权限（字符串）                                      |
|                | 公司预览： preview                                      |
|                | 公司下载： download                                     |

Stage阶段
---------

| **参数**    | **说明**           |
|-------------|--------------------|
| Id          | 阶段ID             |
| Name        | 阶段名称           |
| teamId      | 团队Id             |
| folderId    | 目录Id ：          |
| Comments    | 评论               |
| orderNo     | 阶段的顺序编号     |
| commentList | 阶段的下的评论集合 |

Application申请权限
-------------------

| **参数**      | **说明**                              |
|---------------|---------------------------------------|
| Id            | 申请表的id                            |
| userId        | 申请人的id                            |
| userName      | 申请人的名字                          |
| resourceId    | 资源文件的id ：                       |
| resourceName  | 资源名称                              |
| resourceType  | 资源的类型(部门：0)                   |
| resourceOwner | 资源的归属id                          |
| download      | 布尔类型(true：有下载)                |
| preview       | 布尔类型(true:有预览)                 |
| reason        | 申请理由                              |
| rejectReason  | 拒绝理由                              |
| createDate    | 创建的时间                            |
| status        | 状态：0 没处理 1 处理通过 2处理不通过 |

Subscription订阅内容
--------------------

| **参数**    | **说明**                                    |
|-------------|---------------------------------------------|
| Id          | 订阅内容id                                  |
| userId      | 用户id                                      |
| contentId   | 内容id                                      |
| contentType | 内容的类型 1：团队 2：专委会 3：知识地图 ： |
| contentName | 内容名称                                    |
| createDate  | 创建日期                                    |

SubscriptionNotice订阅动态
--------------------------

| **参数**     | **说明**                                    |
|--------------|---------------------------------------------|
| Id           | 订阅动态id                                  |
| userId       | 用户id                                      |
| resourceId   | 资源id                                      |
| resourceType | 资源的类型 1：团队 2：专委会 3：知识地图 ： |
| resourceName | 资源名称                                    |
| contentId    | 资源所属id                                  |
| contentName  | 资源所属名称                                |
| createDate   | 创建日期                                    |
| read         | 布尔类型：是否已读                          |

KeyWord关键词
-------------

| **参数**   | **说明**              |
|------------|-----------------------|
| id         | 关键字id              |
| content    | 关键字内容            |
| creator    | 搜索关键字的用户名称  |
| creatorId  | 搜索关键字的用户ID ： |
| createDate | 创建日期              |

Authorization授权
-----------------

| **参数**     | **说明**                                                                      |
|--------------|-------------------------------------------------------------------------------|
| id           | 授权id                                                                        |
| description  | 资源描述（资源名称）                                                          |
| scope        | 授权对象范围： 用户 SCOPE_USER =1 角色： SCOPE_ROLE = 2 部门： SCOPE_DEPT = 4 |
| targetId     | 授权对象ID集合 ：                                                             |
| targetName   | 授权对象名称，用逗号分隔开                                                    |
| startDate    | 开始生效时间                                                                  |
| endDate      | 结束生效时间                                                                  |
| creatorId    | 创建者ID                                                                      |
| creatorName  | 创建者Name                                                                    |
| resourceId   | 资源ID 文件：                                                                 |
|              | *RESOURCE_TYPE_FILE* = 1 目录： *RESOURCE_TYPE_FOLDER* = 2                    |
| resourceType | 资源类型                                                                      |
| operations   | 操作码                                                                        |

Operation操作权限
-----------------

| **参数**    | **说明**                                                                                                                                                                                                                             |
|-------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| id          | 权限id（id的值 与 Type值相同）                                                                                                                                                                                                       |
| type        | 权限类型                                                                                                                                                                                                                             |
|             | 操作代码：下载                                                                                                                                                                                                                       |
|             | public static final int CODE_DOWNLOAD = 1;                                                                                                                                                                                           |
|             |                                                                                                                                                                                                                                      |
|             | 操作代码：预览                                                                                                                                                                                                                       |
|             | public static final int CODE_PREVIEW =2; 操作代码：分享                                                                                                                                                                              |
|             | public static final int CODE_PREVIEW =4; 操作代码：收藏                                                                                                                                                                              |
|             | public static final int CODE_PREVIEW =8;                                                                                                                                                                                             |
| description | 描述                                                                                                                                                                                                                                 |

Logs日志
--------

| **参数**      | **说明**                                    |
|---------------|---------------------------------------------|
| Id            | 阶段ID                                      |
| resourceId    | 资源ID                                      |
| resourceName  | 资源名称                                    |
| resourceType  | 资源类型                                    |
| creator       | 创建人名称                                  |
| creatorId     | 创建人ID                                    |
| deptId        | 创建人的默认部门ID                          |
| deptName      | 创建的的默认部门名称                        |
| operationType | 操作类型，见[Operation](#operation操作权限) |
